<?php

namespace App\Http\Controllers;

use App\Exports\aporteReporteExport;
use App\Models\Aporte;
use App\Models\Reunion;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;

class AporteController extends Controller
{
    public function index()
    {
        $aportes = Aporte::select(DB::raw('aporte.*, DATE(aporte.fecha) as fechaAp'), DB::raw('(SELECT COUNT(*) FROM aporte_padres WHERE aporte_padres.id_aporte = aporte.id_aporte) as total'))
            ->orderBy('aporte.id_aporte', 'desc')
            ->paginate(10);



        //$reunion_padres = DB::select("select * from reunion_padres");
        $totalParticipantes = DB::select(" SELECT
            Count(*),
            aporte_padres.id_aporte,
            aporte.titulo
            FROM
            aporte_padres
            INNER JOIN aporte ON aporte_padres.id_aporte = aporte.id_aporte
            GROUP BY id_aporte ");

        return view("vistas/aportes.index", compact("aportes"))->with("totalParticipantes", $totalParticipantes);
    }



    public function store(Request $request)
    {
        $request->validate([
            "txttitulo" => "required",
            "txtdescripcion" => "required",
            "txtmonto" => "required",
            "txtfecha" => "required",
        ]);

        //registrar
        $aporte = new Aporte();
        $aporte->titulo = $request->txttitulo;
        $aporte->descripcion = $request->txtdescripcion;
        $aporte->monto = $request->txtmonto;
        $aporte->fecha = $request->txtfecha;
        $aporte->multiplicar = $request->multiplicar;
        $aporte->save();

        //redireccionar a la vista de agregar participantes 
        return redirect()->route("aportes.vistaAgregarParticipante", $aporte->id_aporte)->with("CORRECTO", "Aporte registrada exitosamente");
    }



    public function update(Request $request, $id)
    {
        $request->validate([
            "txttitulo" => "required",
            "txtdescripcion" => "required",
            "txtmonto" => "required",
            "txtfecha" => "required",
        ]);
        //modificar
        $reunion = Aporte::findOrFail($id);
        $reunion->titulo = $request->txttitulo;
        $reunion->descripcion = $request->txtdescripcion;
        $reunion->monto = $request->txtmonto;
        $reunion->fecha = $request->txtfecha;
        $reunion->save();

        //actualizar el campo monto de la tabla aporte_padres, segun cuantos estudiantes tenga el padre de familia
        $montoAporte = DB::select("SELECT monto FROM aporte WHERE id_aporte=?", [$id]);
        $participantes = DB::select("SELECT * FROM aporte_padres WHERE id_aporte = ?", [$id]);
        foreach ($participantes as $participante) {
            $cantidadHijos = DB::select("SELECT COUNT(*) as cantidad FROM estudiante where id_padre_familia=?", [$participante->id_padre_familia]);
            $montoDebe = $montoAporte[0]->monto * $cantidadHijos[0]->cantidad;
            DB::update("UPDATE aporte_padres SET monto_aporte = ? WHERE id_aporte = ? AND id_padre_familia = ?", [$montoDebe, $id, $participante->id_padre_familia]);
        }


        return redirect()->route("aportes.index")->with("CORRECTO", "Aporte modificada exitosamente");
    }


    public function destroy($id)
    {
        //eliminar
        // verificar si el aporte tiene participantes
        // $participantes = DB::select("SELECT * FROM aporte_padres WHERE id_aporte = ?", [$id]);
        // if (count($participantes) > 0) {
        //     return back()->with("INCORRECTO", "No se puede eliminar el aporte porque tiene participantes vinculados");
        // }


        $aporte = Aporte::findOrFail($id);
        $aporte->delete();
        return redirect()->route("aportes.index")->with("CORRECTO", "Aporte eliminada exitosamente");
    }

    public function addParticipante(Request $request)
    {
        $request->validate([
            "txtidaporte" => "required",
            "txtidparticipante" => "required",
        ]);


        $idParticipantes = explode(",", $request->txtidparticipante);
        //validar si $idParticipantes es un array vacio
        if (empty($idParticipantes)) {
            return back()->with("INCORRECTO", "No se seleccionaron participantes");
        }
        $montoAporte = DB::select("SELECT monto FROM aporte WHERE id_aporte=?", [$request->txtidaporte]);
        $multiplicarAporte = DB::select("SELECT multiplicar FROM aporte WHERE id_aporte=?", [$request->txtidaporte]);
        //insertar cada participante en la tabla reunion_padres
        foreach ($idParticipantes as $idParticipante) {
            //verificar si ya existe el participante en el aporta
            $existe = DB::select("SELECT * FROM aporte_padres WHERE id_aporte = ? AND id_padre_familia = ?", [$request->txtidaporte, $idParticipante]);
            $cantidadHijos = DB::select("SELECT COUNT(*) as cantidad FROM estudiante where id_padre_familia=?", [$idParticipante]);
            if ($multiplicarAporte[0]->multiplicar == "on") {
                $montoDebe = $montoAporte[0]->monto * $cantidadHijos[0]->cantidad;
            } else {
                $montoDebe = $montoAporte[0]->monto;
            }

            if (count($existe) <= 0) {
                DB::insert("INSERT INTO aporte_padres (id_aporte, id_padre_familia, monto_aporte, monto_aportado) VALUES (?, ?, ?, 0)", [$request->txtidaporte, $idParticipante, $montoDebe]);
            }
        }

        return back()->with("CORRECTO", "Participantes agregados exitosamente");
    }

    public function vistaAgregarParticipante($id_aporte)
    {
        $aporte = DB::select("SELECT * FROM aporte WHERE id_aporte = ?", [$id_aporte]);

        // Consulta mejorada que incluye información de si pagaron o no
        $padresFamilia = DB::select("
                SELECT
                    padre_familia.*,
                    cargo.nombre AS cargo,
                    tipo_consanguinidad.nombre AS nombre_consanguinidad,
                    estudiante.nivel,
                    estudiante.grado,
                    CASE
                        WHEN EXISTS (
                            SELECT 1
                            FROM aporte_padres
                            WHERE aporte_padres.id_padre_familia = padre_familia.id_padre_familia
                            AND aporte_padres.id_aporte = $id_aporte
                        ) THEN 'si'
                        ELSE 'no'
                    END AS esta_vinculado_en_reunion,
                    CASE
                        WHEN EXISTS (
                            SELECT 1
                            FROM aporte_padres
                            WHERE aporte_padres.id_padre_familia = padre_familia.id_padre_familia
                            AND aporte_padres.id_aporte = $id_aporte
                            AND aporte_padres.monto_aportado = aporte_padres.monto_aporte
                            AND aporte_padres.monto_aporte > 0
                        ) THEN 'si'
                        ELSE 'no'
                    END AS ha_pagado,
                    (
                        SELECT aporte_padres.monto_aporte 
                        FROM aporte_padres 
                        WHERE aporte_padres.id_padre_familia = padre_familia.id_padre_familia
                        AND aporte_padres.id_aporte = $id_aporte
                        LIMIT 1
                    ) as monto_aporte,
                    (
                        SELECT aporte_padres.monto_aportado
                        FROM aporte_padres 
                        WHERE aporte_padres.id_padre_familia = padre_familia.id_padre_familia
                        AND aporte_padres.id_aporte = $id_aporte
                        LIMIT 1
                    ) as monto_aportado
                FROM
                    padre_familia
                LEFT JOIN
                    cargo ON padre_familia.id_cargo = cargo.id_cargo
                LEFT JOIN
                    tipo_consanguinidad ON padre_familia.tipo_consanguinidad = tipo_consanguinidad.id_tipo_consanguinidad
                LEFT JOIN
                    estudiante ON estudiante.id_padre_familia = padre_familia.id_padre_familia
                WHERE EXISTS (
                    SELECT 1
                    FROM estudiante
                    WHERE estudiante.id_padre_familia = padre_familia.id_padre_familia
                )
                GROUP BY padre_familia.id_padre_familia
        ");

        $nivel = DB::select("SELECT
            estudiante.nivel
            FROM
            estudiante GROUP BY nivel
        ");

        $grado = DB::select("SELECT
            estudiante.grado
            FROM
            estudiante
            GROUP BY grado
        ");

        return view("vistas/aportes.agregarParticipante", compact("padresFamilia"))
            ->with("id_aporte", $id_aporte)
            ->with("aporte", $aporte)
            ->with("nivel", $nivel)
            ->with("grado", $grado);
    }


    public function eliminarParticipante($id_aporte)
    {
        // Solo eliminar a los participantes que NO han pagado completamente
        // Es decir, donde monto_aportado NO es igual a monto_aporte o donde monto_aporte es 0
        $eliminar = DB::delete("
            DELETE FROM aporte_padres 
            WHERE id_aporte = ? 
            AND NOT (monto_aportado = monto_aporte AND monto_aporte > 0)
        ", [$id_aporte]);

        if ($eliminar > 0) {
            return back()->with("CORRECTO", "Se eliminaron {$eliminar} padres que no habían pagado");
        } else {
            return back()->with("INCORRECTO", "No se encontraron padres sin pagar para eliminar");
        }
    }

    public function aportesReporte($id_aporte)
    {
        $datosNoAdeudados = DB::select("SELECT
        aporte_padres.id_aporte_padres,
        aporte_padres.id_aporte,
        aporte_padres.id_padre_familia,
        aporte_padres.monto_aporte,
        aporte_padres.monto_aportado,
        aporte_padres.debe,
        aporte.fecha,
        aporte.monto,
        aporte.descripcion,
        aporte.titulo,
        padre_familia.padre_dni,
        padre_familia.padre_nombres,
        padre_familia.padre_ape_pat,
        padre_familia.padre_ape_mat
        FROM
        aporte_padres
        INNER JOIN aporte ON aporte_padres.id_aporte = aporte.id_aporte
        INNER JOIN padre_familia ON aporte_padres.id_padre_familia = padre_familia.id_padre_familia
        where aporte_padres.id_aporte = ? and (monto_aportado = monto_aporte ) and monto_aporte!=0  order by padre_ape_pat asc", [$id_aporte]);

        $datosAdeudados = DB::select("SELECT
        aporte_padres.id_aporte_padres,
        aporte_padres.id_aporte,
        aporte_padres.id_padre_familia,
        aporte_padres.monto_aporte,
        aporte_padres.monto_aportado,
        aporte_padres.debe,
        aporte.fecha,
        aporte.monto,
        aporte.descripcion,
        aporte.titulo,
        padre_familia.padre_dni,
        padre_familia.padre_nombres,
        padre_familia.padre_ape_pat,
        padre_familia.padre_ape_mat
        FROM
        aporte_padres
        INNER JOIN aporte ON aporte_padres.id_aporte = aporte.id_aporte
        INNER JOIN padre_familia ON aporte_padres.id_padre_familia = padre_familia.id_padre_familia
        where aporte_padres.id_aporte = ? and ((monto_aporte - monto_aportado) > 0 ) and monto_aporte!=0 order by padre_ape_pat asc", [$id_aporte]);

        $tituloAporte = DB::select("SELECT titulo FROM aporte WHERE id_aporte=?", [$id_aporte]);

        $sumaTotalNoAdeudados = DB::select("SELECT SUM(monto_aporte) as sumaTotalNoAdeudados FROM aporte_padres WHERE id_aporte=? and (monto_aportado = monto_aporte ) and monto_aporte!=0", [$id_aporte]);
        $sumaTotalAdeudados = DB::select("SELECT SUM(monto_aporte) as sumaTotalAdeudados FROM aporte_padres WHERE id_aporte=? and ((monto_aporte - monto_aportado) > 0 ) and monto_aporte!=0", [$id_aporte]);
        $sumaTotal = $sumaTotalNoAdeudados[0]->sumaTotalNoAdeudados + $sumaTotalAdeudados[0]->sumaTotalAdeudados;

        $pdf = \App::make('dompdf.wrapper');
        //$pdf->setPaper('a4', 'landscape');//FORMATO HORIZONTAL
        $pdf->loadView('vistas/reportes/reporte_aportes', compact('datosNoAdeudados', "datosAdeudados", "tituloAporte", "sumaTotalNoAdeudados", "sumaTotalAdeudados", "sumaTotal"));
        return $pdf->stream("reporte de aportes.pdf");
    }

    public function aportesReporteExcel($id_aporte)
    {
        return Excel::download(new aporteReporteExport($id_aporte), "aporteReporte.xlsx");
    }

    //actualizacion
    public function eliminarParticipanteSeleccionados($id_aporte, Request $request)
    {
        // Obtener IDs del cuerpo de la solicitud
        $padres_seleccionados = $request->input('padres_seleccionados');
        $ids = explode(',', $padres_seleccionados);

        if (empty($ids)) {
            return back()->with("INCORRECTO", "No se seleccionaron padres para eliminar");
        }

        // El resto del código sigue igual
        $placeholders = implode(',', array_fill(0, count($ids), '?'));

        $eliminar = DB::delete("
            DELETE FROM aporte_padres 
            WHERE id_aporte = ? 
            AND id_padre_familia IN ({$placeholders})
            AND NOT (monto_aportado = monto_aporte AND monto_aporte > 0)
        ", array_merge([$id_aporte], $ids));

        if ($eliminar > 0) {
            return back()->with("CORRECTO", "Se eliminaron {$eliminar} padres seleccionados");
        } else {
            return back()->with("INCORRECTO", "No se pudo eliminar los padres seleccionados. Es posible que algunos ya hayan pagado.");
        }
    }

    public function rendicionCuenta(Request $request)
    {
        $request->validate([
            "id_aporte" => "required",
            "txtfile" => "required",
        ]);

        //eliminar el archivo anterior
        $aporte = DB::select(" select rendicion from aporte where id_aporte=?", [$request->id_aporte]);
        if ($aporte[0]->rendicion != null) {
            $file_path = public_path('storage/ARCHIVOS/pagos/rendicion/' . $aporte[0]->rendicion);
            if (file_exists($file_path)) {
                unlink($file_path);
            }
        }

        //subir el nuevo archivo
        try {
            $file = $request->file('txtfile');
            $nombreArchivo = $request->id_aporte . "." . $file->getClientOriginalExtension();
            $file->move(storage_path('app/public/ARCHIVOS/pagos/rendicion'), $nombreArchivo);
        } catch (\Throwable $th) {
            return back()->with("INCORRECTO", "Error al subir el archivo");
        }

        //actualizar el campo rendicion en la tabla aporte
        $aporte = Aporte::findOrFail($request->id_aporte);
        $aporte->rendicion = $nombreArchivo;
        $aporte->save();
        return back()->with("CORRECTO", "Rendición de cuenta registrada exitosamente");



    }
}
