<?php
// filepath: c:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\app\Models\Aporte.php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Aporte extends Model
{
    use HasFactory;
    
    protected $table = 'aporte';
    protected $primaryKey = 'id_aporte';
    public $timestamps = false;
    
    protected $fillable = [
        'titulo',
        'descripcion',
        'monto',
        'fecha',
        'multiplicar',
        'rendicion'
    ];
    
    // Relaciones
    public function padresFamilia()
    {
        return $this->belongsToMany(PadreFamilia::class, 'aporte_padres', 'id_aporte', 'id_padre_familia')
                    ->withPivot('monto_aporte', 'monto_aportado', 'debe', 'comentario', 'fecha_pago_boucher', 'numero_pago_boucher');
    }
    
    public function aportePadres()
    {
        return $this->hasMany(AportePadres::class, 'id_aporte', 'id_aporte');
    }
}