<?php
// filepath: c:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\app\Models\Estudiante.php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Estudiante extends Model
{
    use HasFactory;
    
    protected $table = 'estudiante';
    protected $primaryKey = 'id_estudiante';
    public $timestamps = false;
    
    protected $fillable = [
        'id_padre_familia',
        'dni',
        'nombres',
        'ape_pat',
        'ape_mat',
        'nivel',
        'grado'
    ];
    
    // Relaciones
    public function padreFamilia()
    {
        return $this->belongsTo(PadreFamilia::class, 'id_padre_familia', 'id_padre_familia');
    }
}