<?php
// filepath: c:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\database\factories\EmpresaFactory.php
namespace Database\Factories;

use App\Models\Empresa;
use Illuminate\Database\Eloquent\Factories\Factory;

class EmpresaFactory extends Factory
{
    protected $model = Empresa::class;

    public function definition()
    {
        return [
            'nombre' => 'I.E. ' . $this->faker->company,
            'cod_modular' => $this->faker->regexify('[A-Z0-9]{8}'),
            'ubicacion' => $this->faker->address,
            'telefono' => $this->faker->phoneNumber,
            'correo' => $this->faker->email,
            'foto_institucion' => 'institucion.jpg',
            'foto_ugel' => 'ugel.jpg',
            'mapa_ubi'=> $this->faker->text
        ];
    }
}