<?php
// filepath: c:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\database\factories\PagoFactory.php
namespace Database\Factories;

use App\Models\Pago;
use App\Models\PadreFamilia;
use App\Models\Usuario;
use Illuminate\Database\Eloquent\Factories\Factory;

class PagoFactory extends Factory
{
    protected $model = Pago::class;

    public function definition()
    {
        static $padreIds = null;
        static $usuarioIds = null;
        
        if ($padreIds === null) {
            $padreIds = PadreFamilia::pluck('id_padre_familia')->toArray();
        }
        
        if ($usuarioIds === null) {
            $usuarioIds = Usuario::pluck('id_usuario')->toArray();
        }
        
        $conceptos = [
            'Cuota anual APAFA',
            'Multa por inasistencia',
            'Actividades escolares',
            'Mejoras de infraestructura',
            'Implementos deportivos'
        ];
        
        $monto = $this->faker->randomElement([10, 20, 30, 50, 100]);
        $pagado = $this->faker->boolean(80);
        $montoPagado = $pagado ? $monto : $this->faker->numberBetween(0, $monto - 1);
        $debe = $monto - $montoPagado;
        
        return [
            'id_padre_familia' => $this->faker->randomElement($padreIds),
            'id_usuario' => $this->faker->randomElement($usuarioIds),
            'pago_concepto' => $this->faker->randomElement($conceptos),
            'monto_pago' => $monto,
            'debe' => $debe,
            'fecha' => $this->faker->dateTimeBetween('-1 year', 'now'),
            'fecha_pago_boucher' => $pagado ? $this->faker->date() : null,
            'numero_pago_boucher' => $pagado ? $this->faker->numerify('######') : null,
            'foto_boucher' => $pagado ? 'boucher_' . $this->faker->randomNumber(6) . '.jpg' : null,
            'comentario' => $pagado ? 'Pago completo' : 'Pendiente'
        ];
    }
}