<?php
// filepath: c:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\database\factories\ReunionFactory.php
namespace Database\Factories;

use App\Models\Reunion;
use App\Models\EstadoReunion;
use Illuminate\Database\Eloquent\Factories\Factory;

class ReunionFactory extends Factory
{
    protected $model = Reunion::class;

    public function definition()
    {
        static $estadoIds = null;
        
        if ($estadoIds === null) {
            $estadoIds = EstadoReunion::pluck('id_estado_reunion')->toArray();
        }
        
        $titulos = [
            'Asamblea general de padres',
            'Elección de junta directiva',
            'Coordinación de actividades anuales',
            'Informe de gestión',
            'Planificación de actividades',
            'Rendición de cuentas',
            'Evaluación de proyectos',
            'Organización de festividades',
            'Mejoras en infraestructura',
            'Capacitación a padres'
        ];
        
        return [
            'id_estado_reunion' => $this->faker->randomElement($estadoIds),
            'titulo' => $this->faker->randomElement($titulos) . ' ' . date('Y'),
            'descripcion' => $this->faker->paragraph(1),
            'multa_precio' => $this->faker->randomElement([10, 15, 20, 25, 30]),
            'fecha' => $this->faker->dateTimeBetween('-3 months', '+3 months')->format('Y-m-d'),
            'hora' => $this->faker->time('H:i:s')
        ];
    }
    
    public function activa()
    {
        return $this->state(function (array $attributes) {
            return [
                'id_estado_reunion' => 1,
                'fecha' => $this->faker->dateTimeBetween('now', '+3 months')->format('Y-m-d'),
            ];
        });
    }
    
    public function culminada()
    {
        return $this->state(function (array $attributes) {
            return [
                'id_estado_reunion' => 2,
                'fecha' => $this->faker->dateTimeBetween('-3 months', 'yesterday')->format('Y-m-d'),
            ];
        });
    }
}