<?php
// filepath: c:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\database\factories\ReunionPadresFactory.php
namespace Database\Factories;

use App\Models\ReunionPadres;
use App\Models\Reunion;
use App\Models\PadreFamilia;
use Illuminate\Database\Eloquent\Factories\Factory;

class ReunionPadresFactory extends Factory
{
    protected $model = ReunionPadres::class;

    public function definition()
    {
        static $reunionIds = null;
        static $padreIds = null;
        
        if ($reunionIds === null) {
            $reunionIds = Reunion::pluck('id_reunion', 'id_estado_reunion')->toArray();
        }
        
        if ($padreIds === null) {
            $padreIds = PadreFamilia::pluck('id_padre_familia')->toArray();
        }
        
        $reunion_id = array_rand($reunionIds);
        $estado_reunion = Reunion::find($reunion_id)->id_estado_reunion;
        
        $asistio = ($estado_reunion == 2) ? $this->faker->boolean(70) : false;
        
        return [
            'id_reunion' => $reunion_id,
            'id_padre_familia' => $this->faker->randomElement($padreIds),
            'asistencia' => $asistio ? $this->faker->dateTimeBetween('-2 months', 'now') : null,
            'asistencia_salida' => $asistio ? $this->faker->dateTimeBetween('-2 months', 'now') : null,
            'detalles' => $asistio ? 'Asistió' : null
        ];
    }
}