<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('padre_familia', function (Blueprint $table) {
            $table->integer('id_padre_familia', true);
            $table->integer('id_cargo')->nullable();
            $table->integer('tipo_consanguinidad')->nullable();
            $table->string('padre_dni', 255)->nullable();
            $table->string('padre_nombres', 255)->nullable();
            $table->string('padre_ape_pat', 255)->nullable();
            $table->string('padre_ape_mat', 255)->nullable();
            $table->string('celular', 255)->nullable();
            $table->string('direccion', 255)->nullable();
            $table->dateTime('fecha_creacion')->nullable();
            
            $table->foreign('id_cargo')
                ->references('id_cargo')
                ->on('cargo')
                ->onUpdate('restrict')
                ->onDelete('restrict');
                
            $table->foreign('tipo_consanguinidad')
                ->references('id_tipo_consanguinidad')
                ->on('tipo_consanguinidad')
                ->onUpdate('restrict')
                ->onDelete('restrict');
        });
    }

    public function down()
    {
        Schema::dropIfExists('padre_familia');
    }
};