<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('estudiante', function (Blueprint $table) {
            $table->integer('id_estudiante', true);
            $table->integer('id_padre_familia')->nullable();
            $table->string('dni', 255)->nullable();
            $table->string('nombres', 255)->nullable();
            $table->string('ape_pat', 255)->nullable();
            $table->string('ape_mat', 255)->nullable();
            $table->string('nivel', 255)->nullable();
            $table->string('grado', 255)->nullable();
            
            $table->foreign('id_padre_familia')
                ->references('id_padre_familia')
                ->on('padre_familia')
                ->onUpdate('restrict')
                ->onDelete('restrict');
        });
    }

    public function down()
    {
        Schema::dropIfExists('estudiante');
    }
};