<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('reunion', function (Blueprint $table) {
            $table->integer('id_reunion', true);
            $table->integer('id_estado_reunion')->nullable();
            $table->string('titulo', 255)->nullable();
            $table->string('descripcion', 255)->nullable();
            $table->decimal('multa_precio', 10, 0)->nullable();
            $table->date('fecha')->nullable();
            $table->time('hora')->nullable();
            
            $table->foreign('id_estado_reunion')
                ->references('id_estado_reunion')
                ->on('estado_reunion')
                ->onUpdate('restrict')
                ->onDelete('restrict');
        });
    }

    public function down()
    {
        Schema::dropIfExists('reunion');
    }
};