<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('reunion_padres', function (Blueprint $table) {
            $table->integer('id_reunion_padres', true);
            $table->integer('id_reunion')->nullable();
            $table->integer('id_padre_familia')->nullable();
            $table->dateTime('asistencia')->nullable();
            $table->dateTime('asistencia_salida')->nullable();
            $table->string('detalles', 255)->nullable();
            
            $table->foreign('id_reunion')
                ->references('id_reunion')
                ->on('reunion')
                ->onUpdate('cascade')
                ->onDelete('cascade');
                
            $table->foreign('id_padre_familia')
                ->references('id_padre_familia')
                ->on('padre_familia')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('reunion_padres');
    }
};