@extends('layouts/app')
@section('titulo', 'Editar Pago')
@section('content')

    @if (session('CORRECTO'))
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "CORRECTO",
                    type: "success",
                    text: "{{ session('CORRECTO') }}",
                    styling: "bootstrap3"
                });
            });
        </script>
    @endif
    @if (session('INCORRECTO'))
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "INCORRECTO",
                    type: "error",
                    text: "{{ session('INCORRECTO') }}",
                    styling: "bootstrap3"
                });
            });
        </script>
    @endif

    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Editar Pago</h4>
                        <p class="card-category">Modifique los datos del pago</p>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('pagos.update', $pago[0]->id_pago) }}" method="POST"
                            enctype="multipart/form-data" id="form-editar-pago">
                            @csrf
                            @method('PUT')

                            @if (isset($esPagoReunion) && $esPagoReunion)
                                <input type="hidden" name="tipo_pago" value="reunion">
                            @endif

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="pago_concepto">Concepto</label>
                                        <input type="text" class="form-control" value="{{ $pago[0]->pago_concepto }}"
                                            readonly>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="monto_pago">Monto del pago</label>
                                        @if (isset($esPagoReunion) && $esPagoReunion)
                                            <input type="number" step="0.01" class="form-control" name="monto_pago"
                                                value="{{ $pago[0]->monto_pago }}" readonly>
                                            <small class="text-danger">El monto no se puede modificar por ser un pago de
                                                multa de reunión</small>
                                        @else
                                            <input type="number" step="0.01" class="form-control" id="monto_pago"
                                                name="monto_pago" value="{{ old('monto_pago', $pago[0]->monto_pago) }}"
                                                required data-monto-original="{{ $pago[0]->monto_pago }}"
                                                @if (isset($montoMaximo)) data-monto-maximo="{{ $montoMaximo }}" @endif>

                                            @if (isset($montoMaximo))
                                                <small class="text-info">El monto máximo permitido es S/.
                                                    {{ number_format($montoMaximo, 2) }}</small>
                                            @endif
                                            <div id="monto-error" class="text-danger d-none">El monto no puede ser mayor al
                                                monto máximo permitido</div>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="comentario">Comentarios</label>
                                        <textarea class="form-control" name="comentario" rows="3">{{ $pago[0]->comentario }}</textarea>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="boucher">Boucher (Imagen o PDF)</label>
                                        <input type="file" class="form-control" name="boucher" accept="image/*,.pdf">
                                        <small class="text-muted">Suba un nuevo archivo solo si desea reemplazar el
                                            existente</small>
                                    </div>
                                </div>
                            </div>

                            @if ($pago[0]->foto_boucher)
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>Boucher actual</label>
                                            <div>
                                                @php
                                                    $extension = pathinfo($pago[0]->foto_boucher, PATHINFO_EXTENSION);
                                                @endphp

                                                @if (in_array(strtolower($extension), ['jpg', 'jpeg', 'png', 'gif']))
                                                    <img src="{{ asset('storage/ARCHIVOS/pagos/' . $pago[0]->foto_boucher) }}"
                                                        style="max-width: 200px; max-height: 200px;" alt="Boucher actual">
                                                @else
                                                    <a href="{{ asset('storage/ARCHIVOS/pagos/' . $pago[0]->foto_boucher) }}"
                                                        target="_blank">
                                                        <i class="fas fa-file-pdf fa-2x text-danger"></i> Ver PDF actual
                                                    </a>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif

                            <div class="row">
                                <div class="col-md-12 text-right">
                                    <a href="#" onclick="event.preventDefault(); window.history.back();" class="btn btn-secondary">Volver atrás</a>
                                    <button type="submit" class="btn btn-primary" id="btn-actualizar">Guardar
                                        cambios</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const montoPagoInput = document.getElementById('monto_pago');
            const montoError = document.getElementById('monto-error');
            const btnActualizar = document.getElementById('btn-actualizar');
            const formEditarPago = document.getElementById('form-editar-pago');

            // Solo aplicar validación si no es pago de reunión y tiene montoMaximo
            if (montoPagoInput && montoPagoInput.dataset.montoMaximo) {
                const montoMaximo = parseFloat(montoPagoInput.dataset.montoMaximo);
                const montoOriginal = parseFloat(montoPagoInput.dataset.montoOriginal);

                montoPagoInput.addEventListener('input', function() {
                    const valor = parseFloat(this.value) || 0;

                    if (valor > montoMaximo) {
                        montoError.classList.remove('d-none');
                        btnActualizar.disabled = true;
                        this.setCustomValidity('El monto no puede ser mayor al monto máximo permitido');
                    } else {
                        montoError.classList.add('d-none');
                        btnActualizar.disabled = false;
                        this.setCustomValidity('');
                    }
                });

                formEditarPago.addEventListener('submit', function(e) {
                    const valor = parseFloat(montoPagoInput.value) || 0;

                    if (valor > montoMaximo) {
                        e.preventDefault();
                        montoError.classList.remove('d-none');
                    }
                });
            }
        });
    </script>

@endsection
