@extends('layouts/app')
@section('titulo', 'Pagos')
@section('content')

    <style>
        .rojo {
            background-color: #ffcccc !important;
            color: rgb(58, 12, 12) !important;
        }

        .verde {
            background-color: #ccffcc !important;
            color: rgb(7, 50, 26) !important;
        }

        .card-block {
            max-height: 400px;

        }

        .encabezado__tabla {
            background-color: rgb(47, 128, 182) !important;
            color: white;
        }

        .resultado {
            background: rgba(26, 150, 123, 0.88);
            color: white;
            margin-bottom: 20px;
        }

        /* Estilo para la tabla de pagos realizados */
        .encabezado__tabla_pagos {
            background-color: rgb(34, 91, 130) !important;
            color: white;
        }

        /* Estilo para las imágenes de boucher */
        .boucher-thumbnail {
            max-width: 100px;
            max-height: 100px;
            cursor: pointer;
        }

        .encabezado-pagos {
            background: rgb(30, 106, 157);
            color: white;
        }

        /* Estilo para la tabla de reuniones */
        .encabezado__tabla_reuniones {
            background-color: rgb(47, 128, 182) !important;
            color: white;
        }
    </style>
    {{-- notificaciones --}}


    @if (session('CORRECTO'))
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "CORRECTO",
                    type: "success",
                    text: "{{ session('CORRECTO') }}",
                    styling: "bootstrap3"
                });
            });
        </script>
    @endif

    @if (session('id_pago'))
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "CORRECTO",
                    type: "success",
                    text: "El pago se realizo con exito",
                    styling: "bootstrap3"
                });
            });


            $(function() {
                window.open("{{ route('pagos.ticketPago', ':id_pago') }}".replace(':id_pago',
                    '{{ session('id_pago') }}'), "_blank");
            });
        </script>
    @endif

    @if (session('id_pagos'))
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "CORRECTO",
                    type: "success",
                    text: "Los pagos se realizaron con éxito",
                    styling: "bootstrap3"
                });
            });

            // Abrir en una nueva pestaña la ruta ticketPagos y enviar los ids de los pagos como parámetro
            $(function() {
                const idPagos = @json(session('id_pagos'));
                const comentarios = @json(session('comentarios'));
                const url = "{{ route('pagos.ticketPagos') }}?id_pagos=" + encodeURIComponent(JSON.stringify(idPagos)) +
                    "&comentarios=" + encodeURIComponent(JSON.stringify(comentarios));
                window.open(url, "_blank");
            });
        </script>
    @endif

    @if (session('INCORRECTO'))
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "INCORRECTO",
                    type: "error",
                    text: "{{ session('INCORRECTO') }}",
                    styling: "bootstrap3"
                });
            });
        </script>
    @endif

    <h4 class="text-center text-secondary">REALIZA TUS PAGOS</h4>

    <div class="card-block" style="margin-bottom: -40px">
        <div class="resultado p-3">
            @foreach ($nombrePadreFamilia as $item)
                {{ $item->nombre }}
            @endforeach
        </div>
    </div>

    <div class="card-block table-responsive table-one">

        <a href="{{ route('historial.descargaPDF', $dni_padre) }}" target="_blank" id="descarga"
            class="btn btn-primary"><i class="fas fa-file-pdf"></i> Imprimir historial</a>

        <!-- Botón de "PAGAR" que se mostrará solo cuando se seleccione al menos un checkbox -->
        <button id="pagarSeleccionados" class="btn btn-secondary" style="display: none" data-toggle="modal"
            data-target="#pagarModal">PAGAR APORTES</button>

        <table id="example2" class="display table table-striped" cellspacing="0" width="100%">
            <thead class="table-primary">
                <tr>
                    <th colspan="12" class="encabezado__tabla">APORTES</th>
                </tr>
                <tr>
                    <th><input type="checkbox" id="selectAll"></th>
                    <th>N°</th>
                    <th>Titulo</th>
                    <th>Monto a aportar</th>
                    <th>Monto aportado</th>
                    <th>Debe</th>
                    <th>Fecha plazo</th>
                    <th>Comentarios</th>
                    <th>Acciones</th>
                </tr>
            </thead>

            <tbody id="tbody">
                @foreach ($historialAportes as $key => $item)
                    <tr class="{{ ($item->debe == null) | ($item->debe > 0) ? 'rojo' : 'verde' }}">
                        <td>
                            @if ($item->debe == null || $item->debe > 0)
                                <input type="checkbox" class="checkboxPago" data-id="{{ $item->id_aporte }}"
                                    data-titulo="{{ $item->titulo }}" data-monto="{{ $item->debe }}"
                                    data-monto-aportado="{{ $item->monto_aportado }}"
                                    data-id-padre="{{ $item->id_padre_familia }}">
                            @else
                                <input type="checkbox" class="checkboxPago" disabled>
                            @endif
                        </td>
                        <td>{{ $key + 1 }}</td>
                        <td>{{ $item->titulo }}</td>
                        {{-- <td>{{ $item->descripcion }}</td> --}}
                        <td>S/. {{ $item->monto }} <b>X {{ $cantidadHijos }} Hijos = {{ $item->monto_aporte }}</b></td>
                        <td>S/. {{ $item->monto_aportado }}</td>
                        <td>S/. {{ $item->debe }}</td>
                        <td>{{ $item->fecha }}</td>

                        <td>{{ $item->comentario }}</td>
                        <td>
                            @if ($item->debe == null || $item->debe > 0)
                                <a href="" data-toggle="modal" data-target="#registrar{{ $item->id_aporte }}"
                                    class="btn btn-sm bg-dark"><i class="fas fa-dollar-sign"></i> Pagar</a>
                                {{-- editar --}}
                                <a href="" data-toggle="modal" data-target="#editar{{ $item->id_aporte }}"
                                    class="btn btn-sm btn-warning"><i class="fas fa-edit"></i></a>
                            @endif
                        </td>
                    </tr>


                    <!-- Modal registrar pago de aportes -->
                    <div class="modal fade" id="registrar{{ $item->id_aporte }}" tabindex="-1"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header d-flex justify-content-between">
                                    <h5 class="modal-title w-100" id="exampleModalLabel">Registrar Pago</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{ route('pagos.store') }}" method="POST"
                                        data-form-id="formAporte-{{ $item->id_aporte }}" enctype="multipart/form-data">
                                        @csrf

                                        <input type="hidden" name="txtidaporte" value="{{ $item->id_aporte }}">
                                        <input type="hidden" name="txtidpadre" value="{{ $item->id_padre_familia }}">
                                        <input type="hidden" name="txtidusuario" value="{{ Auth::user()->id_usuario }}">

                                        {{-- fecha pago --}}
                                        <div class="mb-4 px-2 col-12">
                                            <label>Fecha de pago/boucher</label>
                                            <input required type="date" placeholder="Fecha de pago" name="txtfechapago"
                                                class="input input__text" value="{{ old('txtfechapago', date('Y-m-d')) }}">
                                            @error('txtfechapago')
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            @enderror
                                        </div>

                                        {{-- numero de recibo --}}
                                        <div class="mb-4 px-2 col-12">
                                            <label>N° operacion/boucher</label>
                                            <input type="text" name="txtnumerorecibo" class="input input__text"
                                                value="{{ old('txtnumerorecibo') }}">
                                            @error('txtnumerorecibo')
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            @enderror
                                        </div>

                                        <div class="mb-4 px-2 col-12">
                                            <label>Monto que queda por aportar</label>
                                            <input required readonly type="text" placeholder="Monto a aportar"
                                                name="txtmontoaportar" class="input input__text"
                                                data-form-id="txtmontoaportar-{{ $item->id_aporte }}"
                                                value="{{ old('txtmontoaportar', $item->monto_aporte - $item->monto_aportado) }}">
                                            @error('txtmontoaportar')
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            @enderror
                                        </div>


                                        <div class="mb-4 px-2 col-12">
                                            <label>Monto aportado</label>
                                            <input required type="number" step="0.5" placeholder=""
                                                class="input input__text" name="txtmontoaportado"
                                                data-form-id="txtmontoaportado-{{ $item->id_aporte }}"
                                                class="monto-aportado" value="{{ old('txtmontoaportado') }}">
                                            @error('txtmontoaportado')
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            @enderror
                                        </div>

                                        <div class="mb-4 px-2 col-12">
                                            <label>Monto que debe</label>
                                            <input required readonly type="text" placeholder=""
                                                data-form-id="txtmontodebe-{{ $item->id_aporte }}"
                                                class="input input__text" name="txtmontodebe"
                                                value="{{ old('txtmontodebe', $item->debe) }}">
                                            @error('txtmontodebe')
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            @enderror
                                        </div>


                                        <div class="mb-4 px-2 col-12">
                                            <label>Foto/boucher</label>
                                            <input type="file" name="txtfotoboucher" class="input input__text"
                                                value="{{ old('txtfotoboucher') }}" accept=".png, .jpg, .jpeg, .pdf">
                                            @error('txtfotoboucher')
                                                <p class="error-message text-danger p-2">{{ $message }}</p>
                                            @enderror
                                        </div>


                                        <div class="mb-4 px-2 col-12">
                                            <label>Comentarios</label>
                                            <textarea name="txtcomentarios" rows="1" class="input input__text"
                                                data-form-id="txtcomentarios-{{ $item->id_aporte }}">{{ old('txtcomentarios') }}</textarea>
                                            @error('txtcomentarios')
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            @enderror
                                        </div>


                                        <div class="text-right p-2">
                                            <a data-dismiss="modal" class="btn btn-secondary btn-rounded">Atras</a>
                                            <button type="submit" value="ok" name="btnmodificar"
                                                class="btn btn-primary btn-rounded">Registrar pago</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>

                    <!-- Modal editar pago de aportes -->
                    <div class="modal fade" id="editar{{ $item->id_aporte }}" tabindex="-1"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header d-flex justify-content-between">
                                    <h5 class="modal-title w-100" id="exampleModalLabel">Modificar Pago</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{ route('pagos.editarPago') }}" method="POST"
                                        data-form-id="formAporte-{{ $item->id_aporte }}">
                                        @csrf

                                        <input type="hidden" name="txtidaporte" value="{{ $item->id_aporte }}">
                                        <input type="hidden" name="txtidpadre" value="{{ $item->id_padre_familia }}">
                                        <input type="hidden" name="txtidusuario"
                                            value="{{ Auth::user()->id_usuario }}">

                                        <div class="mb-4 px-2 col-12">
                                            <label>Monto que queda por aportar</label>
                                            <input required type="text" placeholder="Monto a aportar"
                                                name="txtmontoaportar" class="input input__text"
                                                data-form-id="txtmontoaportar-{{ $item->id_aporte }}"
                                                value="{{ old('txtmontoaportar', $item->monto_aporte - $item->monto_aportado) }}">
                                            @error('txtmontoaportar')
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            @enderror
                                        </div>


                                        {{-- comentarios --}}
                                        <div class="mb-4 px-2 col-12">
                                            <label>Comentarios</label>
                                            <textarea name="txtcomentarios" required class="input input__text"
                                                data-form-id="txtcomentarios-{{ $item->id_aporte }}">{{ old('txtcomentarios', $item->comentario) }}</textarea>
                                            @error('txtcomentarios')
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            @enderror
                                        </div>



                                        <div class="text-right p-2">
                                            <a data-dismiss="modal" class="btn btn-secondary btn-rounded">Atras</a>
                                            <button type="submit" value="ok" name="btnmodificar"
                                                class="btn btn-primary btn-rounded">Modificar</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
                @endforeach

            </tbody>
        </table>
    </div>

    <!-- Modal para mostrar los aportes seleccionados -->
    <div class="modal fade" id="pagarModal" tabindex="-1" aria-labelledby="pagarModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header encabezado-pagos">
                    <h5 class="modal-title w-100" id="pagarModalLabel">
                        <i class="fas fa-money-bill-wave mr-2"></i> Registrar Pagos Múltiples
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="formPago" method="POST" action="{{ route('pagos.registrarPagos') }}"
                        enctype="multipart/form-data">
                        @csrf
                        <div id="aportesSeleccionados"></div>

                        <div class="row mb-3">
                            <!-- Datos comunes para todos los pagos -->
                            <div class="col-md-6 mb-3">
                                <label class="font-weight-bold">Fecha de pago/boucher:</label>
                                <input required type="date" name="fecha_pago" class="form-control"
                                    value="{{ date('Y-m-d') }}">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="font-weight-bold">N° operación/boucher:</label>
                                <input type="text" name="numero_recibo" class="form-control"
                                    placeholder="Ingrese el número de operación">
                            </div>

                            <div class="col-md-12 mb-4">
                                <label class="font-weight-bold">Imagen de comprobante/boucher:</label>
                                <input type="file" name="foto_boucher" class="form-control-file"
                                    accept=".png, .jpg, .jpeg, .pdf">
                                <small class="text-muted">Formatos permitidos: jpg, jpeg, png, pdf</small>
                            </div>
                        </div>

                        <div class="card mb-4">
                            <div class="card-header bg-light">
                                <h6 class="mb-0"><i class="fas fa-list-alt mr-2"></i> Detalle de Aportes Seleccionados
                                </h6>
                            </div>
                            <div class="card-body" id="modalBody">
                                <!-- Los detalles de los aportes seleccionados se agregarán aquí -->
                            </div>
                            <div class="card-footer bg-light">
                                <div class="text-right">
                                    <h5 id="totalPagar" class="font-weight-bold text-primary mb-0">Total a pagar: S/. 0.00
                                    </h5>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="font-weight-bold">Comentarios adicionales:</label>
                            <textarea class="form-control" name="comentarios" rows="2"
                                placeholder="Ingrese comentarios sobre este pago (opcional)"></textarea>
                        </div>

                        <div class="text-center mt-4">
                            <button type="button" class="btn btn-secondary mr-2" data-dismiss="modal">
                                <i class="fas fa-times mr-1"></i> Cancelar
                            </button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-check mr-1"></i> Confirmar Pagos
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="card-block table-responsive">
        <!-- Botón de "PAGAR MULTAS" que se mostrará solo cuando se seleccione al menos un checkbox de reunión -->
        <button id="pagarReunionesSeleccionadas" class="btn btn-secondary" style="display: none"
            data-toggle="modal" data-target="#pagarReunionesModal">PAGAR MULTAS</button>

        <table id="example3" class="display table table-striped" cellspacing="0" width="100%">
            <thead class="table-primary">
                <tr>
                    <th colspan="9" class="encabezado__tabla">REUNIONES</th>
                </tr>
                <tr>
                    <th><input type="checkbox" id="selectAllReuniones"></th>
                    <th>N°</th>
                    <th>Titulo</th>
                    {{-- <th>Descripcion</th> --}}
                    <th>Multa</th>
                    <th>Fecha reunion</th>
                    <th>Asistencia</th>
                    <th>Estado de la reunion</th>
                    <th>Acciones</th>
                </tr>
            </thead>

            <tbody id="tbodyreuniones">
                @foreach ($historialReuniones as $key => $item)
                    <tr
                        class="{{ $item->asistencia == null && ($item->detalles == '' || $item->detalles == null) ? 'rojo' : 'verde' }}">
                        <td>
                            @if ($item->asistencia == null && ($item->detalles == '' || $item->detalles == null))
                                <input type="checkbox" class="checkboxReunion" data-id="{{ $item->id_reunion }}"
                                    data-titulo="{{ $item->titulo }}" data-multa="{{ $item->multa_precio }}"
                                    data-id-padre="{{ $item->id_padre_familia }}">
                            @else
                                <input type="checkbox" class="checkboxReunion" disabled>
                            @endif
                        </td>
                        <td>{{ $key + 1 }}</td>
                        <td>{{ $item->titulo }}</td>
                        {{-- <td>{{ $item->descripcion }}</td> --}}
                        <td>S/. {{ $item->multa_precio }}</td>
                        <td>{{ $item->fecha }} - {{ $item->hora }}</td>
                        <td>
                            @if ($item->asistencia == null and ($item->detalles == '' or $item->detalles == null))
                                <span class="btn btn-sm btn-danger">Falta</span>
                            @else
                                @if ($item->asistencia != null or $item->asistencia != '')
                                    <span class="btn btn-sm btn-success">{{ $item->asistencia }}</span>
                                @else
                                    <span class="btn btn-sm btn-success">{{ $item->detalles }}</span>
                                @endif
                            @endif
                        </td>
                        <td>
                            @if ($item->estado == 'ACTIVO')
                                <span class="btn btn-sm btn-success">{{ $item->estado }}</span>
                            @else
                                <span class="btn btn-sm btn-danger">{{ $item->estado }}</span>
                            @endif
                        </td>
                        <td>
                            @if ($item->asistencia == null and ($item->detalles == '' or $item->detalles == null))
                                <a href="" data-toggle="modal" data-target="#multa{{ $item->id_reunion }}"
                                    class="btn btn-sm bg-dark"><i class="fas fa-dollar-sign"></i> Pagar</a>
                            @else
                                <a href="" class="btn btn-sm bg-dark disabled"><i class="fas fa-dollar-sign"></i>
                                    Pagar</a>
                            @endif
                        </td>
                    </tr>

                    <!-- Modal registrar multa de reunion-->
                    <div class="modal fade" id="multa{{ $item->id_reunion }}" tabindex="-1"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header d-flex justify-content-between">
                                    <h5 class="modal-title w-100" id="exampleModalLabel">Registrar Pago de Multa</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{ route('pagos.pagarMultaReunion') }}" method="POST"
                                        enctype="multipart/form-data" data-form-id="formMulta-{{ $item->id_reunion }}">
                                        @csrf

                                        <input type="hidden" name="txtidreunion" value="{{ $item->id_reunion }}">
                                        <input type="hidden" name="txtidpadre" value="{{ $item->id_padre_familia }}">
                                        <input type="hidden" name="txtidusuario"
                                            value="{{ Auth::user()->id_usuario }}">

                                        {{-- fecha pago --}}
                                        <div class="mb-4 px-2 col-12">
                                            <label>Fecha de pago/boucher</label>
                                            <input required type="date" placeholder="Fecha de pago"
                                                name="txtfechapago" class="input input__text"
                                                value="{{ old('txtfechapago', date('Y-m-d')) }}">
                                            @error('txtfechapago')
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            @enderror
                                        </div>

                                        {{-- numero de recibo --}}
                                        <div class="mb-4 px-2 col-12">
                                            <label>N° operacion/boucher</label>
                                            <input type="text" name="txtnumerorecibo" class="input input__text"
                                                value="{{ old('txtnumerorecibo') }}">
                                            @error('txtnumerorecibo')
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            @enderror
                                        </div>

                                        <div class="mb-4 px-2 col-12">
                                            <label>Multa de la reunión</label>
                                            <input required readonly type="text" placeholder="Multa de la reunión"
                                                name="txtmulta" class="input input__text"
                                                data-form-id="txtmulta-{{ $item->id_reunion }}"
                                                value="{{ old('txtmulta', $item->multa_precio) }}">
                                            @error('txtmulta')
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            @enderror
                                        </div>

                                        <div class="mb-4 px-2 col-12">
                                            <label>Monto pago</label>
                                            <input required readonly type="number" step="0.5" placeholder=""
                                                class="input input__text" name="txtpago"
                                                data-form-id="txtpago-{{ $item->id_reunion }}" class="monto-aportado"
                                                value="{{ old('txtpago', $item->multa_precio) }}">
                                            @error('txtpago')
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            @enderror
                                        </div>

                                        <div class="mb-4 px-2 col-12">
                                            <label>Foto/boucher</label>
                                            <input type="file" name="txtfotoboucher" class="input input__text"
                                                value="{{ old('txtfotoboucher') }}" accept=".png, .jpg, .jpeg, .pdf">
                                            @error('txtfotoboucher')
                                                <p class="error-message text-danger p-2">{{ $message }}</p>
                                            @enderror
                                        </div>

                                        <div class="mb-4 px-2 col-12">
                                            <label>Comentarios</label>
                                            <textarea name="txtcomentarios" rows="1" class="input input__text"
                                                data-form-id="txtcomentarios-{{ $item->id_reunion }}">{{ old('txtcomentarios') }}</textarea>
                                            @error('txtcomentarios')
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            @enderror
                                        </div>

                                        <div class="text-right p-2">
                                            <a data-dismiss="modal" class="btn btn-secondary btn-rounded">Atras</a>
                                            <button type="submit" value="ok" name="btnmodificar"
                                                class="btn btn-primary btn-rounded">Registrar pago</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
                @endforeach

            </tbody>
        </table>
    </div>

    <!-- Modal para mostrar las reuniones seleccionadas y pagar multas -->
    <div class="modal fade" id="pagarReunionesModal" tabindex="-1" aria-labelledby="pagarReunionesModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header encabezado-pagos">
                    <h5 class="modal-title w-100" id="pagarReunionesModalLabel">
                        <i class="fas fa-money-bill-wave mr-2"></i> Registrar Pagos Múltiples de Multas
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="formPagoMultipleReuniones" method="POST"
                        action="{{ route('pagos.registrarPagosMultas') }}" enctype="multipart/form-data">
                        @csrf
                        <div id="reunionesSeleccionadas"></div>

                        <div class="row mb-3">
                            <!-- Datos comunes para todos los pagos -->
                            <div class="col-md-6 mb-3">
                                <label class="font-weight-bold">Fecha de pago/boucher:</label>
                                <input required type="date" name="fecha_pago" class="form-control"
                                    value="{{ date('Y-m-d') }}">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="font-weight-bold">N° operación/boucher:</label>
                                <input type="text" name="numero_recibo" class="form-control"
                                    placeholder="Ingrese el número de operación">
                            </div>

                            <div class="col-md-12 mb-4">
                                <label class="font-weight-bold">Imagen de comprobante/boucher:</label>
                                <input type="file" name="foto_boucher" class="form-control-file"
                                    accept=".png, .jpg, .jpeg, .pdf">
                                <small class="text-muted">Formatos permitidos: jpg, jpeg, png, pdf</small>
                            </div>
                        </div>

                        <div class="card mb-4">
                            <div class="card-header bg-light">
                                <h6 class="mb-0"><i class="fas fa-list-alt mr-2"></i> Detalle de Multas Seleccionadas
                                </h6>
                            </div>
                            <div class="card-body" id="modalBodyReuniones">
                                <!-- Los detalles de las reuniones seleccionadas se agregarán aquí -->
                            </div>
                            <div class="card-footer bg-light">
                                <div class="text-right">
                                    <h5 id="totalPagarReuniones" class="font-weight-bold text-primary mb-0">Total a pagar:
                                        S/. 0.00</h5>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="font-weight-bold">Comentarios adicionales:</label>
                            <textarea class="form-control" name="comentarios" rows="2"
                                placeholder="Ingrese comentarios sobre este pago (opcional)"></textarea>
                        </div>

                        <div class="text-center mt-4">
                            <button type="button" class="btn btn-secondary mr-2" data-dismiss="modal">
                                <i class="fas fa-times mr-1"></i> Cancelar
                            </button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-check mr-1"></i> Confirmar Pagos
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Tabla de pagos realizados -->
    <div class="card-block table-responsive">
        <table id="example4" class="display table table-striped" cellspacing="0" width="100%">
            <thead class="table-primary">
                <tr>
                    <th colspan="9" class="encabezado__tabla_pagos">PAGOS REALIZADOS</th>
                </tr>
                <tr>
                    <th>N°</th>
                    <th>Concepto</th>
                    <th>Monto pagado</th>
                    <th>Fecha de pago</th>
                    <th>Registrado por</th>
                    <th>Estado</th>
                    <th>Boucher</th>
                    <th>Comentarios</th>
                    <th>Opciones</th>
                </tr>
            </thead>

            <tbody>
                @foreach ($historialPagos as $key => $pago)
                    <tr>
                        <td>{{ $key + 1 }}</td>
                        <td>{{ $pago->pago_concepto }}</td>
                        <td>S/. {{ $pago->monto_pago }}</td>
                        <td>{{ $pago->fecha }}</td>
                        <td>{{ $pago->nombres_usuario }}</td>
                        <td>
                            @if (isset($pago->estado))
                                @if ($pago->estado == 'ANULADO')
                                    <span class="badge bg-danger">{{ $pago->estado }}</span>
                                @elseif($pago->estado == 'EDITADO')
                                    <span class="badge bg-warning">{{ $pago->estado }}</span>
                                @else
                                    <span class="badge bg-success">VIGENTE</span>
                                @endif
                            @else
                                <span class="badge bg-success">VIGENTE</span>
                            @endif
                        </td>
                        <td>
                            @if ($pago->foto_boucher)
                                @php
                                    $extension = pathinfo($pago->foto_boucher, PATHINFO_EXTENSION);
                                @endphp

                                @if (in_array(strtolower($extension), ['jpg', 'jpeg', 'png', 'gif']))
                                    <img src="{{ asset('storage/ARCHIVOS/pagos/' . $pago->foto_boucher) }}"
                                        class="boucher-thumbnail"
                                        onclick="window.open('{{ asset('storage/ARCHIVOS/pagos/' . $pago->foto_boucher) }}', '_blank')"
                                        alt="Boucher">
                                @else
                                    <a href="{{ asset('storage/ARCHIVOS/pagos/' . $pago->foto_boucher) }}"
                                        target="_blank">
                                        <i class="fas fa-file-pdf fa-2x text-danger"></i>
                                    </a>
                                @endif
                            @else
                                <span class="text-muted">Sin boucher</span>
                            @endif
                        </td>
                        <td>{{ $pago->comentario }}</td>
                        <td>

                            @if ((!isset($pago->estado) || $pago->estado != 'ANULADO') && $pago->monto_pago > 0)
                                <a href="{{ route('pagos.ticketPago', $pago->id_pago) }}" target="_blank"
                                    class="btn btn-sm btn-info">
                                    <i class="fas fa-print"></i> Ticket
                                </a>
                                <a href="{{ route('pagos.edit', $pago->id_pago) }}" class="btn btn-sm btn-warning">
                                    <i class="fas fa-edit"></i> Editar
                                </a>
                                <a href="{{ route('pagos.anular', $pago->id_pago) }}" class="btn btn-sm btn-danger"
                                    onclick="return confirm('¿Está seguro que desea anular este pago?')">
                                    <i class="fas fa-ban"></i> Anular
                                </a>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <!-- Tabla de historial de modificaciones -->
    <div class="card-block table-responsive mt-4">
        <table id="historial-modificaciones" class="display table table-striped" cellspacing="0" width="100%">
            <thead class="table-primary">
                <tr>
                    <th colspan="3" class="encabezado__tabla_pagos">HISTORIAL DE MODIFICACIONES DE PAGOS</th>
                    <th class="encabezado__tabla_pagos text-right">
                        @if (isset($historialModificaciones) && count($historialModificaciones) > 0)
                            <a href="{{ route('pagos.limpiarHistorial', $id_padre_familia) }}" class="btn btn-sm btn-danger"
                                onclick="return confirm('¿Está seguro que desea eliminar todo el historial? Esta acción no se puede deshacer.')">
                                <i class="fas fa-trash"></i> Eliminar todo el historial
                            </a>
                        @endif
                    </th>
                </tr>
                <tr>
                    <th>N°</th>
                    <th>Descripción</th>
                    <th>Realizado por</th>
                    <th>Fecha</th>
                </tr>
            </thead>

            <tbody>
                @if (isset($historialModificaciones) && count($historialModificaciones) > 0)
                    @foreach ($historialModificaciones as $key => $modificacion)
                        <tr>
                            <td>{{ $key + 1 }}</td>
                            <td>{{ $modificacion->descripcion }}</td>
                            <td>{{ $modificacion->registrado_por }}</td>
                            <td>{{ date('d/m/Y H:i', strtotime($modificacion->fecha)) }}</td>
                        </tr>
                    @endforeach
                @else
                    <tr>
                        <td colspan="4" class="text-center">No hay historial de modificaciones</td>
                    </tr>
                @endif
            </tbody>
        </table>
    </div>


    <script>
        let formAporte = document.querySelectorAll('[data-form-id^="formAporte-"]');
        let montoAportado = document.querySelectorAll('[data-form-id^="txtmontoaportado-"]');
        let montoDebe = document.querySelectorAll('[data-form-id^="txtmontodebe-"]');
        montoAportado.forEach((elemento) => {
            elemento.addEventListener('keyup', () => {
                let id = elemento.getAttribute('data-form-id');
                let idAporte = id.split('-')[1];
                let montoAportar = document.querySelector(`[data-form-id="txtmontoaportar-${idAporte}"]`)
                    .value;
                let montoAportado = parseFloat(elemento.value);
                let montoDebe = document.querySelector(`[data-form-id="txtmontodebe-${idAporte}"]`).value;
                //validar que el monto aportado no sea mayor al monto a aportar caso contrario poner el valor del monto a aportar
                if (montoAportado > montoAportar) {
                    elemento.value = montoAportar;
                    montoAportado = montoAportar;
                }
                //validar que el monto aportado no sea menor a 0 caso contrario poner el valor 0
                if (montoAportado < 0) {
                    elemento.value = 0;
                    montoAportado = 0;
                }
                //validar si esta vacio el monto aportado poner el valor 0
                if (montoAportado == '') {
                    elemento.value = 0;
                    montoAportado = 0;
                }
                let montoTotal = montoAportar - montoAportado;
                document.querySelector(`[data-form-id="txtmontodebe-${idAporte}"]`).value = montoTotal;
            })
        })
    </script>

    <script>
        let formMulta = document.querySelectorAll('[data-form-id^="formMulta-"]');
        let montoPago = document.querySelectorAll('[data-form-id^="txtpago-"]');
        let montoMulta = document.querySelectorAll('[data-form-id^="txtmulta-"]');

        montoPago.forEach((elemento) => {
            elemento.addEventListener('keyup', () => {
                let id = elemento.getAttribute('data-form-id');
                let idAporte = id.split('-')[1];
                let montoAportar = document.querySelector(`[data-form-id="txtmulta-${idAporte}"]`)
                    .value;
                let montoPago = parseFloat(elemento.value);
                let montoMulta = document.querySelector(`[data-form-id="txtmulta-${idAporte}"]`).value;
                //validar que el monto aportado no sea mayor al monto a aportar caso contrario poner el valor del monto a aportar
                if (montoPago > montoAportar) {
                    elemento.value = montoAportar;
                    montoPago = montoAportar;
                }
                //validar que el monto aportado no sea menor a 0 caso contrario poner el valor 0
                if (montoPago < 0) {
                    elemento.value = 0;
                    montoPago = 0;
                }
                //validar si esta vacio el monto aportado poner el valor 0
                if (montoPago == '') {
                    elemento.value = 0;
                    montoPago = 0;
                }
                // validar que el monto sea igual a la multa
                if (montoPago != montoMulta) {
                    elemento.value = montoMulta;
                    montoPago = montoMulta;
                }
            })
        })
    </script>

    <script>
        // Función para mostrar/ocultar sección de edición de imagen
        function toggleEditImage(idAporte) {
            const editSection = document.getElementById(`editImageSection-${idAporte}`);
            const saveButton = document.getElementById(`btnGuardarCambios-${idAporte}`);
            if (editSection.style.display === 'none') {
                editSection.style.display = 'block';
                saveButton.style.display = 'block';
            } else {
                editSection.style.display = 'none';
                saveButton.style.display = 'none';
            }
        }
    </script>

    <script>
        $(document).ready(function() {
            // Manejar el checkbox "Seleccionar todo"
            $('#selectAll').on('change', function() {
                $('.checkboxPago:not(:disabled)').prop('checked', $(this).prop('checked'));
                actualizarBotonPagar();
                actualizarModalPagos();
            });

            // Manejar los checkboxes individuales
            $('.checkboxPago').on('change', function() {
                actualizarBotonPagar();
                actualizarModalPagos();

                // Si desmarcamos algún checkbox, desmarcar también "Seleccionar todo"
                if (!$(this).prop('checked')) {
                    $('#selectAll').prop('checked', false);
                }

                // Si todos los checkboxes disponibles están marcados, marcar "Seleccionar todo"
                if ($('.checkboxPago:not(:disabled):checked').length === $('.checkboxPago:not(:disabled)')
                    .length) {
                    $('#selectAll').prop('checked', true);
                }
            });

            // Función para actualizar la visibilidad del botón "PAGAR"
            function actualizarBotonPagar() {
                const haySeleccionados = $('.checkboxPago:checked').length > 0;
                $('#pagarSeleccionados').toggle(haySeleccionados);
            }

            // Función para actualizar el contenido del modal con los aportes seleccionados
            function actualizarModalPagos() {
                const aportesSeleccionados = [];
                let totalAPagar = 0;
                let htmlDetalles = '';
                let inputsHtml = '';
                let idPadre = null;

                $('.checkboxPago:checked').each(function() {
                    const checkbox = $(this);
                    const id = checkbox.data('id');
                    const titulo = checkbox.data('titulo');
                    const monto = parseFloat(checkbox.data('monto'));
                    const montoAportado = parseFloat(checkbox.data('monto-aportado') || 0);
                    idPadre = checkbox.data('id-padre');

                    aportesSeleccionados.push({
                        id_aporte: id,
                        titulo: titulo,
                        monto: monto,
                        montoAportado: montoAportado
                    });

                    totalAPagar += monto;

                    // Crear una fila en la tabla para cada aporte seleccionado
                    htmlDetalles += `
                        <div class="card mb-3 border-left-primary">
                            <div class="card-body py-3">
                                <div class="row">
                                    <div class="col-md-7">
                                        <h6 class="font-weight-bold text-primary mb-1">${titulo}</h6>
                                        <div class="small text-muted mb-2">
                                            Monto pendiente: S/. ${monto.toFixed(2)}
                                        </div>
                                        <div class="small">
                                            Monto aportado previamente: S/. ${montoAportado.toFixed(2)}
                                        </div>
                                    </div>
                                    <div class="col-md-5">
                                        <label class="font-weight-bold">Monto a pagar:</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">S/.</span>
                                            </div>
                                            <input type="number" class="form-control monto-individual" 
                                                name="aportes[${id}][monto]" value="${monto.toFixed(2)}" 
                                                min="0" max="${monto}" step="0.01" required
                                                data-original="${monto}">
                                            <input type="hidden" name="aportes[${id}][id_aporte]" value="${id}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    `;
                });

                if (idPadre) {
                    inputsHtml = `<input type="hidden" name="id_padre_familia" value="${idPadre}">`;
                }

                $('#modalBody').html(htmlDetalles ||
                    '<p class="text-center text-muted">No se han seleccionado aportes</p>');
                $('#aportesSeleccionados').html(inputsHtml);
                $('#totalPagar').text(`Total a pagar: S/. ${totalAPagar.toFixed(2)}`);

                // Agregar evento para recalcular el total cuando cambian los montos individuales
                $('.monto-individual').on('input', function() {
                    let nuevoTotal = 0;
                    $('.monto-individual').each(function() {
                        nuevoTotal += parseFloat($(this).val() || 0);
                    });
                    $('#totalPagar').text(`Total a pagar: S/. ${nuevoTotal.toFixed(2)}`);

                    // Validar que el monto no exceda el valor original
                    const max = parseFloat($(this).attr('data-original'));
                    const valor = parseFloat($(this).val() || 0);
                    if (valor > max) {
                        $(this).val(max.toFixed(2));
                    }
                    if (valor < 0) {
                        $(this).val(0);
                    }
                });
            }

            // Código para reuniones
            // Manejar el checkbox "Seleccionar todo" para reuniones
            $('#selectAllReuniones').on('change', function() {
                $('.checkboxReunion:not(:disabled)').prop('checked', $(this).prop('checked'));
                actualizarBotonPagarReuniones();
                actualizarModalPagosReuniones();
            });

            // Manejar los checkboxes individuales para reuniones
            $('.checkboxReunion').on('change', function() {
                actualizarBotonPagarReuniones();
                actualizarModalPagosReuniones();

                // Si desmarcamos algún checkbox, desmarcar también "Seleccionar todo"
                if (!$(this).prop('checked')) {
                    $('#selectAllReuniones').prop('checked', false);
                }

                // Si todos los checkboxes disponibles están marcados, marcar "Seleccionar todo"
                if ($('.checkboxReunion:not(:disabled):checked').length === $(
                        '.checkboxReunion:not(:disabled)').length) {
                    $('#selectAllReuniones').prop('checked', true);
                }
            });

            // Función para actualizar la visibilidad del botón "PAGAR MULTAS"
            function actualizarBotonPagarReuniones() {
                const haySeleccionados = $('.checkboxReunion:checked').length > 0;
                $('#pagarReunionesSeleccionadas').toggle(haySeleccionados);
            }

            // Función para actualizar el contenido del modal con las reuniones seleccionadas
            function actualizarModalPagosReuniones() {
                const reunionesSeleccionadas = [];
                let totalAPagar = 0;
                let htmlDetalles = '';
                let inputsHtml = '';
                let idPadre = null;

                $('.checkboxReunion:checked').each(function() {
                    const checkbox = $(this);
                    const id = checkbox.data('id');
                    const titulo = checkbox.data('titulo');
                    const multa = parseFloat(checkbox.data('multa'));
                    idPadre = checkbox.data('id-padre');

                    reunionesSeleccionadas.push({
                        id_reunion: id,
                        titulo: titulo,
                        multa: multa
                    });

                    totalAPagar += multa;

                    // Crear una fila en la tabla para cada reunión seleccionada
                    htmlDetalles += `
                        <div class="card mb-3 border-left-danger">
                            <div class="card-body py-3">
                                <div class="row">
                                    <div class="col-md-7">
                                        <h6 class="font-weight-bold text-danger mb-1">${titulo}</h6>
                                        <div class="small text-muted mb-2">
                                            Multa: S/. ${multa.toFixed(2)}
                                        </div>
                                    </div>
                                    <div class="col-md-5">
                                        <label class="font-weight-bold">Monto a pagar:</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">S/.</span>
                                            </div>
                                            <input type="number" class="form-control multa-individual" 
                                                name="multas[${id}][monto]" value="${multa.toFixed(2)}" 
                                                min="0" max="${multa}" step="0.01" required
                                                data-original="${multa}" readonly>
                                            <input type="hidden" name="multas[${id}][id_reunion]" value="${id}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    `;
                });

                if (idPadre) {
                    inputsHtml = `<input type="hidden" name="id_padre_familia" value="${idPadre}">
                                  <input type="hidden" name="tipo_pago" value="reunion">`;
                }

                $('#modalBodyReuniones').html(htmlDetalles ||
                    '<p class="text-center text-muted">No se han seleccionado reuniones</p>');
                $('#reunionesSeleccionadas').html(inputsHtml);
                $('#totalPagarReuniones').text(`Total a pagar: S/. ${totalAPagar.toFixed(2)}`);

                // Agregar evento para recalcular el total cuando cambian los montos individuales
                $('.multa-individual').on('input', function() {
                    let nuevoTotal = 0;
                    $('.multa-individual').each(function() {
                        nuevoTotal += parseFloat($(this).val() || 0);
                    });
                    $('#totalPagarReuniones').text(`Total a pagar: S/. ${nuevoTotal.toFixed(2)}`);
                });
            }
        });
    </script>

@endsection
