<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Ticket de Pagos Múltiples</title>
    <style>
        @page {
            size: 80mm auto;
        }

        html,
        body {
            font-family: 'Courier New', Courier, monospace;
            font-size: 9px;
            margin: 0;
            width: 100%;
            background-color: white;
        }

        html {
            margin: 15px;
        }

        .ticket-container {
            max-width: 80mm;
            margin: 0 auto;
        }

        .header {
            text-align: center;
            border-bottom: 1px solid #000;
            padding-bottom: 3px;
            margin-bottom: 5px;
        }

        .header h1 {
            font-size: 12px;
            font-weight: bold;
            margin: 0 0 2px 0;
        }

        .header p {
            margin: 0;
            font-size: 8px;
        }

        .divider {
            border-bottom: 1px dashed #000;
            margin: 5px 0;
        }

        .solid-divider {
            border-bottom: 1px solid #000;
            margin: 5px 0;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 5px;
        }

        table td {
            padding: 2px;
            vertical-align: top;
        }

        td.label {
            font-weight: bold;
            width: 40%;
        }

        td.value {
            width: 60%;
        }

        .section-title {
            text-align: center;
            font-weight: bold;
            background-color: #f0f0f0;
            padding: 2px 0;
            margin: 3px 0;
        }

        .footer {
            text-align: center;
            border-top: 1px dashed #000;
            padding-top: 3px;
            margin-top: 5px;
        }

        .footer p {
            margin: 2px 0;
        }

        .text-center {
            text-align: center;
        }

        .text-bold {
            font-weight: bold;
        }

        .monto {
            font-size: 10px;
            font-weight: bold;
        }

        .payment-item {
            margin-bottom: 5px;
            padding-bottom: 5px;
        }
    </style>
</head>

<body>
    <div class="ticket-container">
        <div class="header">
            <h1>TICKET DE PAGOS MÚLTIPLES</h1>
        </div>

        @foreach ($empresa as $item)
            <div class="section-title">DATOS DE LA INSTITUCIÓN</div>
            <table>
                <tr>
                    <td class="label">Cod modular:</td>
                    <td class="value">{{ $item->cod_modular }}</td>
                </tr>
                <tr>
                    <td class="label">Nombre:</td>
                    <td class="value">{{ $item->nombre }}</td>
                </tr>
                <tr>
                    <td class="label">Ubicación:</td>
                    <td class="value">{{ $item->ubicacion }}</td>
                </tr>
                <tr>
                    <td class="label">Teléfono:</td>
                    <td class="value">{{ $item->telefono }}</td>
                </tr>
            </table>
        @endforeach

        <div class="divider"></div>

        <div class="section-title">DATOS DEL APODERADO</div>
        <table>
            <tr>
                <td class="label">DNI:</td>
                <td class="value">{{ $pagos->first()->padre_dni }}</td>
            </tr>
            <tr>
                <td class="label">Apoderado:</td>
                <td class="value">{{ $pagos->first()->padre_nombres }} {{ $pagos->first()->padre_ape_pat }} {{ $pagos->first()->padre_ape_mat }}</td>
            </tr>
            <tr>
                <td class="label">Fecha:</td>
                <td class="value">{{ date('d/m/Y') }}</td>
            </tr>
            @if(isset($comentarios) && !empty($comentarios))
            <tr>
                <td class="label">Comentarios:</td>
                <td class="value">{{ array_values($comentarios)[0] ?? '' }}</td>
            </tr>
            @endif
        </table>

        <div class="divider"></div>
        <div class="section-title">DETALLE DE PAGOS</div>

        @php $total = 0; @endphp
        @foreach($pagos as $pago)
            <div class="payment-item">
                <table>
                    <tr>
                        <td class="label">Concepto:</td>
                        <td class="value">{{ $pago->pago_concepto }}</td>
                    </tr>
                    <tr>
                        <td class="label">Monto:</td>
                        <td class="value monto">S/ {{ number_format($pago->monto_pago, 2) }}</td>
                    </tr>
                </table>
            </div>
            @php $total += $pago->monto_pago; @endphp
        @endforeach

        <div class="solid-divider"></div>

        <table>
            <tr>
                <td class="label">TOTAL PAGADO:</td>
                <td class="value monto">S/ {{ number_format($total, 2) }}</td>
            </tr>
        </table>

        <div class="solid-divider"></div>

        <p class="text-center">Atendido por: {{ $pagos->first()->nombres }}</p>

        <div class="footer">
            <p class="text-bold">¡Gracias por su pago!</p>
            <p>Fecha: {{ date('d/m/Y') }} - Hora: {{ date('H:i:s') }}</p>
            <p>Conserve este comprobante para cualquier consulta</p>
        </div>
    </div>

    <script>
        window.onload = function() {
            setTimeout(function() {
                window.print();
            }, 500);
        }
    </script>
</body>

</html>
