<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema APAFA - Gestión escolar eficiente</title>
    <meta name="description"
        content="Sistema de gestión para Asociaciones de Padres de Familia que permite administrar asistencias, pagos y generar reportes de forma eficiente.">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

    <style>
        :root {
            --primary: #0079eb;
            --primary-dark: #00517e;
            --secondary: #00a2ff;
            --dark: #0d2730;
            --text-dark: #333;
            --text-light: #6c7a86;
            --light: #f8f9fa;
            --white: #ffffff;
            --success: #46c35f;
            --warning: #f29824;
            --danger: #fa424a;
            --info: #00a8ff;
        }

        * {
            padding: 0;
            margin: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', 'Nunito', sans-serif;
            background-color: var(--light);
            color: var(--text-dark);
            line-height: 1.6;
            overflow-x: hidden;
        }

        .btn {
            display: inline-block;
            padding: 0.6rem 1.5rem;
            border-radius: 4px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
            border: none;
            cursor: pointer;
            text-align: center;
        }

        .btn-primary {
            background-color: var(--primary);
            color: var(--white);
        }

        .btn-primary:hover {
            background-color: var(--secondary);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 121, 235, 0.2);
        }

        .btn-lg {
            padding: 0.8rem 2rem;
            font-size: 1.1rem;
        }

        /* Nuevos botones */
        .btn-outline {
            background-color: transparent;
            color: var(--primary);
            border: 2px solid var(--primary);
        }

        .btn-outline:hover {
            background-color: var(--primary);
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 121, 235, 0.2);
        }

        .btn-secondary {
            background-color: var(--secondary);
            color: var(--white);
        }

        .btn-secondary:hover {
            background-color: var(--primary);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 121, 235, 0.2);
        }

        /* Estilos mejorados para el navbar */
        .navbar {
            padding: 0.8rem 2rem;
            background-color: rgba(255, 255, 255, 0.98);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            position: fixed;
            width: 100%;
            top: 0;
            z-index: 1000;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all 0.3s ease;
        }

        .institution-details {
            text-align: left;
            margin-top: 10px;
        }

        .institution-details p {
            padding: 5px;
        }

        .navbar-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            width: 100%;
        }

        .navbar-brand {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--primary-dark);
            text-decoration: none;
            display: flex;
            align-items: center;
        }

        .navbar-menu {
            display: flex;
            gap: 1.5rem;
            align-items: center;
        }

        .navbar-links {
            display: flex;
            gap: 1.5rem;
            align-items: center;
            list-style: none;
            margin: 0;
            padding: 0;
        }

        .nav-link {
            color: var(--text-dark);
            text-decoration: none;
            font-weight: 600;
            font-size: 0.95rem;
            padding: 0.5rem 0;
            position: relative;
            transition: all 0.3s ease;
        }

        .nav-link:after {
            content: '';
            position: absolute;
            width: 0;
            height: 2px;
            background-color: var(--primary);
            bottom: 0;
            left: 0;
            transition: width 0.3s ease;
        }

        .nav-link:hover {
            color: var(--primary);
        }

        .nav-link:hover:after {
            width: 100%;
        }

        .navbar-toggle {
            display: none;
            background: none;
            border: none;
            cursor: pointer;
            font-size: 1.5rem;
            color: var(--primary-dark);
        }

        /* Estilos responsive para el navbar */
        @media (max-width: 992px) {
            .navbar {
                padding: 0.7rem 1.5rem;
            }

            .navbar-toggle {
                display: block;
                order: 1;
                z-index: 2001;
            }

            .navbar-menu {
                position: fixed;
                top: 0;
                right: -100%;
                width: 80%;
                max-width: 300px;
                height: 100vh;
                background-color: var(--white);
                flex-direction: column;
                align-items: flex-start;
                padding: 5rem 2rem 2rem;
                transition: right 0.3s ease;
                box-shadow: -5px 0 15px rgba(0, 0, 0, 0.1);
                z-index: 2000;
                overflow-y: auto;
            }

            .navbar-menu.active {
                right: 0;
            }

            .navbar-links {
                flex-direction: column;
                align-items: flex-start;
                width: 100%;
                gap: 1rem;
            }

            .nav-link {
                display: block;
                width: 100%;
                padding: 0.7rem 0;
                border-bottom: 1px solid rgba(0, 0, 0, 0.05);
            }

            .navbar-brand {
                order: 0;
            }

            .navbar-actions {
                order: 2;
                margin-left: auto;
                margin-right: 1rem;
            }

            .navbar-overlay {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100vh;
                background-color: rgba(0, 0, 0, 0.5);
                z-index: 1999;
                display: none;
            }

            .navbar-overlay.active {
                display: block;
            }

            body.menu-open {
                overflow: hidden;
            }
        }

        .navbar.scrolled {
            padding: 0.7rem 2rem;
        }

        .navbar-brand {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--primary-dark);
            text-decoration: none;
            display: flex;
            align-items: center;
        }

        .navbar-brand img {
            height: 40px;
            margin-right: 10px;
        }

        /* Hero section mejorado */
        .hero-section {
            position: relative;
            background-image: url("{{ asset('img-inicio/fondo.png') }}");
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            color: white;
            margin-top: 60px;
            /* Altura aproximada de la navbar */
        }

        .hero-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, rgba(0, 64, 75, 0.85) 0%, rgba(0, 41, 67, 0.9) 100%);
            z-index: 1;
        }

        .hero-content {
            position: relative;
            z-index: 2;
            max-width: 800px;
            padding: 0 20px;
        }

        .hero-title {
            font-size: 3.5rem;
            margin-bottom: 1.5rem;
            color: white;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
            animation: fadeInUp 1s ease;
        }

        .hero-subtitle {
            font-size: 1.5rem;
            margin-bottom: 2.5rem;
            color: rgba(255, 255, 255, 0.9);
            animation: fadeInUp 1s ease 0.2s forwards;
            opacity: 0;
        }

        .hero-buttons {
            display: flex;
            gap: 20px;
            justify-content: center;
            margin-top: 20px;
            animation: fadeInUp 1s ease 0.4s forwards;
            opacity: 0;
        }

        @media (max-width: 576px) {
            .hero-buttons {
                flex-direction: column;
                gap: 15px;
            }
        }

        /* Sección de estadísticas */
        .stats-section {
            padding: 4rem 0;
            background-color: var(--white);
            text-align: center;
        }

        .stats-container {
            display: flex;
            justify-content: space-around;
            flex-wrap: wrap;
            gap: 30px;
        }

        .stat-item {
            flex: 1;
            min-width: 200px;
            padding: 20px;
        }

        .stat-number {
            font-size: 3rem;
            font-weight: 700;
            color: var(--primary);
            margin-bottom: 0.5rem;
        }

        .stat-description {
            font-size: 1.1rem;
            color: var(--text-light);
        }

        /* Search section */
        .search-section {
            padding: 5rem 0;
            background-color: #f8f9fa;
            position: relative;
        }

        .search-section::before {
            content: '';
            position: absolute;
            top: -50px;
            left: 0;
            right: 0;
            height: 100px;
            background: linear-gradient(to bottom right, transparent 49%, var(--white) 50%);
        }

        .container {
            width: 90%;
            max-width: 1200px;
            margin: 0 auto;
        }

        .search-card {
            background-color: var(--white);
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            padding: 2.5rem;
            max-width: 600px;
            margin: 0 auto;
            transition: transform 0.3s ease;
        }

        .search-card:hover {
            transform: translateY(-5px);
        }

        .search-title {
            text-align: center;
            font-size: 2rem;
            color: var(--primary-dark);
            margin-bottom: 1.8rem;
            position: relative;
            padding-bottom: 15px;
        }

        .search-title::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 3px;
            background-color: var(--primary);
        }

        .form {
            display: flex;
            flex-direction: column;
            gap: 20px;
        }

        .form p {
            text-align: center;
            margin-bottom: 15px;
            color: var(--text-light);
            font-size: 1.1rem;
        }

        input {
            padding: 16px;
            outline: none;
            font-size: 16px;
            border: 1px solid #e1e5eb;
            border-radius: 6px;
            transition: all 0.3s ease;
            background-color: #f9fafc;
        }

        input:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(0, 121, 235, 0.2);
            background-color: var(--white);
        }

        .buscar {
            padding: 16px 10px;
            outline: none;
            color: white;
            font-size: 16px;
            cursor: pointer;
            width: 100%;
            text-decoration: none;
            text-align: center;
            font-weight: bold;
            background: var(--primary);
            border: none;
            border-radius: 6px;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .buscar:hover {
            background: var(--secondary);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 121, 235, 0.2);
        }

        .buscar:active {
            transform: translateY(0);
        }

        /* Benefits section */
        .benefits-section {
            padding: 5rem 0;
            background-color: var(--white);
            position: relative;
        }

        .section-title {
            text-align: center;
            font-size: 2.2rem;
            color: var(--primary-dark);
            margin-bottom: 1rem;
            position: relative;
        }

        .section-subtitle {
            text-align: center;
            font-size: 1.1rem;
            color: var(--text-light);
            margin-bottom: 3rem;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }

        .benefits-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 2rem;
        }

        .benefit-card {
            background-color: var(--white);
            padding: 2.5rem;
            border-radius: 12px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease;
            border-bottom: 3px solid transparent;
            display: flex;
            flex-direction: column;
            align-items: center;
            text-align: center;
        }

        .benefit-card:hover {
            transform: translateY(-8px);
            border-bottom: 3px solid var(--primary);
            box-shadow: 0 12px 20px rgba(0, 0, 0, 0.1);
        }

        .benefit-icon {
            width: 70px;
            height: 70px;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: rgba(0, 121, 235, 0.1);
            border-radius: 50%;
            margin-bottom: 1.5rem;
            color: var(--primary);
            font-size: 1.8rem;
        }

        .benefit-title {
            font-size: 1.4rem;
            color: var(--primary-dark);
            margin-bottom: 1rem;
        }

        .benefit-text {
            color: var(--text-light);
            font-size: 1rem;
            line-height: 1.6;
        }

        /* Sección de testimonios */
        .testimonials-section {
            padding: 5rem 0;
            background-color: #f0f7ff;
        }

        .testimonials-container {
            display: flex;
            flex-wrap: wrap;
            gap: 30px;
            justify-content: center;
        }

        .testimonial-card {
            background-color: var(--white);
            border-radius: 12px;
            padding: 30px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            max-width: 350px;
            position: relative;
            transition: transform 0.3s ease;
        }

        .testimonial-card:hover {
            transform: translateY(-10px);
        }

        .testimonial-text {
            font-style: italic;
            margin-bottom: 20px;
            color: var(--text-dark);
            line-height: 1.7;
        }

        .testimonial-text:before {
            content: '"';
            font-size: 4rem;
            position: absolute;
            top: 10px;
            left: 20px;
            color: rgba(0, 121, 235, 0.1);
            font-family: sans-serif;
        }

        .testimonial-author {
            display: flex;
            align-items: center;
        }

        .testimonial-avatar {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            margin-right: 15px;
            object-fit: cover;
        }

        .testimonial-info h4 {
            margin: 0;
            color: var(--primary-dark);
            font-size: 1.1rem;
        }

        .testimonial-info p {
            margin: 0;
            color: var(--text-light);
            font-size: 0.9rem;
        }

        /* Sección FAQ */
        .faq-section {
            padding: 5rem 0;
            background-color: var(--light);
        }

        .faq-container {
            max-width: 800px;
            margin: 0 auto;
        }

        .faq-item {
            margin-bottom: 20px;
            background-color: var(--white);
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.05);
        }

        .faq-question {
            padding: 20px;
            background-color: var(--white);
            color: var(--primary-dark);
            font-weight: 600;
            cursor: pointer;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all 0.3s ease;
        }

        .faq-question:hover {
            background-color: rgba(0, 121, 235, 0.05);
        }

        .faq-question i {
            transition: transform 0.3s ease;
        }

        .faq-question.active i {
            transform: rotate(180deg);
        }

        .faq-answer {
            padding: 0 20px;
            max-height: 0;
            overflow: hidden;
            color: var(--text-light);
            transition: all 0.3s ease;
        }

        .faq-answer.active {
            padding: 0 20px 20px;
            max-height: 1000px;
        }

        /* CTA Section */
        .cta-section {
            padding: 5rem 0;
            background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
            color: white;
            text-align: center;
        }

        .cta-title {
            font-size: 2.5rem;
            margin-bottom: 1.5rem;
        }

        .cta-text {
            font-size: 1.2rem;
            margin-bottom: 2rem;
            max-width: 700px;
            margin-left: auto;
            margin-right: auto;
        }

        /* Footer */
        .footer {
            background-color: var(--dark);
            color: white;
            padding: 4rem 0 2rem;
        }

        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 40px;
            margin-bottom: 40px;
        }

        .footer-column h3 {
            color: var(--white);
            margin-bottom: 20px;
            position: relative;
            display: inline-block;
        }

        .footer-column h3:after {
            content: '';
            position: absolute;
            left: 0;
            bottom: -8px;
            height: 2px;
            width: 30px;
            background-color: var(--secondary);
        }

        .footer-links {
            list-style: none;
            padding: 0;
        }

        .footer-links li {
            margin-bottom: 10px;
        }

        .footer-links a {
            color: rgba(255, 255, 255, 0.7);
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .footer-links a:hover {
            color: var(--secondary);
            padding-left: 5px;
        }

        .footer-social {
            display: flex;
            gap: 15px;
            margin-top: 20px;
        }

        .social-icon {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: rgba(255, 255, 255, 0.1);
            color: white;
            transition: all 0.3s ease;
        }

        .social-icon:hover {
            background-color: var(--secondary);
            transform: translateY(-3px);
        }

        .footer-bottom {
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            padding-top: 20px;
            text-align: center;
        }

        .footer-text {
            margin: 0;
            font-size: 0.9rem;
            opacity: 0.8;
        }

        /* Message styles */
        .mensaje-error {
            padding: 15px;
            background-color: rgba(250, 66, 74, 0.1);
            color: var(--danger);
            font-weight: 500;
            margin-top: 15px;
            border-radius: 6px;
            border-left: 4px solid var(--danger);
            display: flex;
            align-items: center;
        }

        .mensaje-error:before {
            content: '⚠️';
            margin-right: 10px;
            font-size: 1.2rem;
        }

        /* Animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes pulse {
            0% {
                transform: scale(1);
            }

            50% {
                transform: scale(1.05);
            }

            100% {
                transform: scale(1);
            }
        }

        @media (max-width: 768px) {
            .hero-title {
                font-size: 2.5rem;
            }

            .hero-subtitle {
                font-size: 1.2rem;
            }

            .search-card {
                padding: 1.5rem;
            }

            .benefits-grid {
                grid-template-columns: 1fr;
            }

            .navbar {
                padding: 0.8rem 1rem;
            }
        }

        /* Agrega este estilo para mensajes de éxito */
        .mensaje-info,
        .mensaje-success {
            padding: 15px;
            font-weight: 500;
            margin-top: 15px;
            border-radius: 6px;
            display: flex;
            align-items: center;
        }

        .mensaje-info {
            background-color: rgba(0, 168, 255, 0.1);
            color: var (--info);
            border-left: 4px solid var(--info);
        }

        .mensaje-info:before {
            content: 'ℹ️';
            margin-right: 10px;
            font-size: 1.2rem;
        }

        .mensaje-success {
            background-color: rgba(70, 195, 95, 0.1);
            color: var(--success);
            border-left: 4px solid var(--success);
        }

        .mensaje-success:before {
            content: '✅';
            margin-right: 10px;
            font-size: 1.2rem;
        }

        .header-institucional {
            margin-top: 0;
            animation: fadeInDown 0.5s ease;
        }

        @keyframes fadeInDown {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
        }

        .institucion-info {
            display: flex;
            align-items: center;
            gap: 1.5rem;
        }

        .logo-container {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .logo-institucion {
            height: 70px;
            border-radius: 8px;
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.1);
        }

        .logo-ugel {
            height: 50px;
        }

        .institucion-detalles h1 {
            font-size: 1.4rem;
            color: var(--primary-dark);
            margin-bottom: 0.3rem;
            font-weight: 700;
        }

        .cod-modular {
            font-size: 0.85rem;
            color: var (--text-light);
            margin-bottom: 0.5rem;
        }

        .contacto-container {
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
            text-align: right;
        }

        .contacto-item {
            display: flex;
            align-items: center;
            justify-content: flex-end;
            gap: 0.5rem;
            color: var(--text-light);
            font-size: 0.9rem;
        }

        .contacto-item i {
            color: var(--primary);
            font-size: 1rem;
        }

        /* Ajustes de Responsive */
        @media (max-width: 992px) {
            .header-content {
                flex-direction: column;
                gap: 1rem;
            }

            .contacto-container {
                text-align: center;
            }

            .contacto-item {
                justify-content: center;
            }
        }

        @media (max-width: 768px) {
            .institucion-info {
                flex-direction: column;
                text-align: center;
                gap: 1rem;
            }

            .institucion-detalles {
                text-align: center;
            }

            .logo-container {
                justify-content: center;
            }
        }

        .hero-section {
            margin-top: 60px;
            /* Altura aproximada de la navbar */
        }

        /* Sección Nosotros */
        .about-section {
            padding: 5rem 0;
            background-color: #f8f9fa;
        }

        .about-container {
            display: flex;
            flex-wrap: wrap;
            gap: 30px;
            align-items: center;
            text-align: center;
        }

        .about-image {
            flex: 1;
            min-width: 300px;
            margin: auto;
        }

        .about-image img {
            width: 100%;
            max-width: 300px;
            height: auto;
            border-radius: 10px;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
        }

        .about-content {
            flex: 1;
            min-width: 300px;
        }

        .about-title {
            color: var(--primary-dark);
            margin-bottom: 20px;
            font-size: 2.2rem;
        }

        .about-text {
            color: var(--text-light);
            margin-bottom: 20px;
            line-height: 1.7;
            text-align: justify;
        }

        /* Sección Reuniones */
        .meetings-section {
            padding: 5rem 0;
            background-color: var(--white);
        }

        .meetings-list {
            margin-top: 2rem;
        }

        .meeting-card {
            background-color: var(--white);
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            padding: 25px;
            margin-bottom: 20px;
            border-left: 4px solid var(--primary);
            transition: all 0.3s ease;
        }

        .meeting-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
        }

        .meeting-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }

        .meeting-title {
            font-size: 1.3rem;
            color: var(--primary-dark);
            margin: 0;
        }

        .meeting-date {
            display: flex;
            align-items: center;
            gap: 5px;
            color: var(--text-light);
            font-weight: 500;
        }

        .meeting-date i {
            color: var(--primary);
        }

        .meeting-status {
            display: inline-block;
            padding: 5px 12px;
            border-radius: 30px;
            font-size: 0.8rem;
            font-weight: 600;
            margin-top: 10px;
        }

        .meeting-status.active {
            background-color: rgba(70, 195, 95, 0.1);
            color: var(--success);
        }

        .meeting-status.pending {
            background-color: rgba(242, 152, 36, 0.1);
            color: var(--warning);
        }

        .meeting-description {
            margin-top: 15px;
            color: var(--text-light);
        }

        .meeting-details {
            display: flex;
            gap: 20px;
            margin-top: 15px;
        }

        .meeting-detail {
            display: flex;
            align-items: center;
            gap: 7px;
        }

        .meeting-detail i {
            color: var(--primary);
        }

        /* Sección Aportes */
        .contributions-section {
            padding: 5rem 0;
            background-color: #f0f7ff;
        }

        .contributions-list {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 20px;
        }

        .contribution-card {
            background-color: var(--white);
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            padding: 25px;
            margin-bottom: 20px;
            transition: all 0.3s ease;
            width: 49%;
            min-width: 350px;
        }

        .contribution-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
        }

        .contribution-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }

        .contribution-title {
            font-size: 1.3rem;
            color: var(--primary-dark);
            margin: 0;
        }

        .contribution-amount {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--primary);
        }

        .contribution-description {
            color: var(--text-light);
            margin-bottom: 15px;
        }

        .contribution-date {
            display: flex;
            align-items: center;
            gap: 5px;
            color: var(--text-light);
            font-size: 0.9rem;
        }

        .contribution-date i {
            color: var(--primary);
        }

        /* Sección Contacto */
        .contact-section {
            padding: 5rem 0;
            background-color: var(--white);
        }

        .contact-container {
            display: flex;
            flex-wrap: wrap;
            gap: 30px;
        }

        .contact-info {
            flex: 1;
            min-width: 300px;
        }

        .contact-method {
            display: flex;
            align-items: flex-start;
            margin-bottom: 25px;
            gap: 15px;
        }

        .contact-icon {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background-color: rgba(0, 121, 235, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary);
            font-size: 1.2rem;
        }

        .contact-details h3 {
            margin: 0 0 5px;
            color: var(--primary-dark);
            font-size: 1.2rem;
        }

        .contact-details p {
            margin: 0;
            color: var(--text-light);
            line-height: 1.5;
        }

        .contact-map {
            flex: 1;
            min-width: 300px;
            height: 400px;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        }

        .contact-map iframe {
            width: 100%;
            height: 100%;
            border: none;
        }

        /* Estilos para No Data */
        .no-data {
            text-align: center;
            padding: 40px 20px;
            background-color: #f8f9fa;
            border-radius: 10px;
            color: var(--text-light);
        }

        .no-data i {
            font-size: 3rem;
            color: var(--primary);
            margin-bottom: 20px;
            opacity: 0.5;
        }

        .no-data p {
            font-size: 1.1rem;
            margin-bottom: 0;
        }

        .rendicion {
            background: rgb(0, 113, 154);
            color: white;
            padding: 5px 15px;
            border-radius: 10px;
            margin-top: 50px;
            text-decoration: none;
            font-size: 14px;
        }

        .rendicion:hover {
            background: rgb(0, 81, 110);
        }
    </style>
</head>

<body class="antialiased">
    <!-- Header Institucional -->


    <!-- Navbar -->
    <nav class="navbar">
        <div class="navbar-container">
            <a href="#" class="navbar-brand">
                {{-- <span>Sistema APAFA</span> --}}
                <img src="{{ asset('storage/ARCHIVOS/empresa/' . $foto_institucion) }}" alt="Logo de la institución">
            </a>

            <button class="navbar-toggle" id="menu-toggle">
                <i class="fas fa-bars"></i>
            </button>

            <div class="navbar-overlay" id="overlay"></div>

            <div class="navbar-menu" id="navbar-menu">
                <ul class="navbar-links">
                    <li><a href="#" class="nav-link">INICIO</a></li>
                    {{-- <li><a href="#nosotros" class="nav-link">NOSOTROS</a></li> --}}
                    <li><a href="#consulta" class="nav-link">CONSULTA</a></li>
                    <li><a href="#reuniones" class="nav-link">REUNIONES</a></li>
                    <li><a href="#aportes" class="nav-link">APORTES</a></li>
                    <li><a href="#contacto" class="nav-link">CONTÁCTANOS</a></li>
                </ul>
                <div class="navbar-actions">
                    <a href="{{ route('home') }}" class="btn btn-primary">INGRESAR</a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="hero-overlay"></div>
        <div class="hero-content">
            <h1 class="hero-title">{{ $nombre_institucion }}</h1>
            <p class="hero-subtitle">Una solución completa para administrar asistencias, pagos y mantener informados a
                los padres de familia</p>
            <div class="hero-buttons">
                <a href="#consulta" class="btn btn-primary btn-lg">Consultar mi historial</a>
                <a href="{{ route('home') }}" class="btn btn-outline btn-lg">Acceder al sistema</a>
            </div>
        </div>
    </section>


    <!-- About Us Section (Nosotros) -->
    <section id="nosotros" class="about-section">
        <div class="container">
            <h2 class="section-title">Nuestra Institución</h2>
            <p class="section-subtitle">Conozca más sobre nuestra institución educativa y su compromiso con la educación
            </p>

            <div class="about-container">
                <div class="about-image">
                    <img src="{{ asset('storage/ARCHIVOS/empresa/' . $empresa->foto_institucion) }}"
                        alt="Nuestra Institución">
                    <div class="institution-details">
                        <p><strong>Código Modular:</strong> {{ $empresa->cod_modular }}</p>
                        <p><strong>Dirección:</strong> {{ $empresa->ubicacion }}</p>
                        <p><strong>Teléfono:</strong> {{ $empresa->telefono }}</p>
                        <p><strong>Correo:</strong> {{ $empresa->correo }}</p>
                    </div>
                </div>
                <div class="about-content">
                    <h3 class="about-title">{{ $empresa->nombre }}</h3>
                    <p class="about-text">
                        Somos una institución educativa comprometida con brindar una educación de calidad a todos
                        nuestros estudiantes.
                        Nuestro objetivo es formar personas íntegras, con valores y habilidades que les permitan
                        enfrentar los retos del futuro.
                    </p>
                    <p class="about-text">
                        La Asociación de Padres de Familia (APAFA) es un órgano de colaboración fundamental en nuestra
                        institución,
                        que trabaja de la mano con la dirección para mejorar la calidad educativa y el bienestar de los
                        estudiantes.
                    </p>

                </div>
            </div>
        </div>
    </section>

    <!-- Search/Consultation Section -->
    <section id="consulta" class="search-section">
        <div class="container">
            <h2 class="section-title">Consulta tu historial</h2>
            {{-- <p class="section-subtitle">Ingrese su DNI para acceder a su información de asistencias y pagos</p> --}}

            <div class="search-card">
                <div id="respuesta"></div>
                <div class="form">
                    @csrf
                    <p>Ingrese su DNI para acceder a su información de asistencias y pagos</p>
                    <input id="dni" autofocus type="number" name="dni"
                        placeholder="DNI del padre de familia">
                    <div class="group__button">
                        <a id="buscar" href="asistencia-buscar" class="buscar">BUSCAR MI HISTORIAL</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Meetings Section (Reuniones) -->
    <section id="reuniones" class="meetings-section">
        <div class="container">
            <h2 class="section-title">Próximas Reuniones</h2>
            <p class="section-subtitle">Mantente informado sobre las próximas reuniones de la APAFA</p>

            <div class="meetings-list">
                @if (isset($reuniones) && count($reuniones) > 0)
                    @foreach ($reuniones as $reunion)
                        <div class="meeting-card">
                            <div class="meeting-header">
                                <h3 class="meeting-title">{{ $reunion->titulo }}</h3>
                                <div class="meeting-date">
                                    <i class="far fa-calendar-alt"></i>
                                    <span>{{ date('d/m/Y', strtotime($reunion->fecha)) }}</span>
                                </div>
                            </div>

                            <div class="meeting-status {{ $reunion->id_estado_reunion == 1 ? 'active' : 'pending' }}">
                                {{ $reunion->id_estado_reunion == 1 ? 'Activa' : 'Pendiente' }}
                            </div>

                            <p class="meeting-description">{{ $reunion->descripcion }}</p>

                            <div class="meeting-details">
                                <div class="meeting-detail">
                                    <i class="far fa-clock"></i>
                                    <span>{{ date('h:i A', strtotime($reunion->hora)) }}</span>
                                </div>
                                @if ($reunion->multa_precio > 0)
                                    <div class="meeting-detail">
                                        <i class="fas fa-exclamation-circle"></i>
                                        <span>Multa por inasistencia: S/. {{ $reunion->multa_precio }}</span>
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="no-data">
                        <i class="far fa-calendar-times"></i>
                        <p>No hay reuniones programadas actualmente.</p>
                    </div>
                @endif
            </div>
        </div>
    </section>

    <!-- Contributions Section (Aportes) -->
    <section id="aportes" class="contributions-section">
        <div class="container">
            <h2 class="section-title">Aportes y Cuotas</h2>
            <p class="section-subtitle">Información sobre los aportes vigentes de la APAFA</p>

            <div class="contributions-list">
                @if (isset($aportes) && count($aportes) > 0)
                    @foreach ($aportes as $aporte)
                        <div class="contribution-card">
                            <div class="contribution-header">
                                <h3 class="contribution-title">{{ $aporte->titulo }}</h3>
                                <div class="contribution-amount">S/. {{ $aporte->monto }}</div>
                            </div>

                            <p class="contribution-description">{{ $aporte->descripcion }}</p>

                            <div class="contribution-date">
                                <i class="far fa-calendar-check"></i>
                                <span>Fecha: {{ date('d/m/Y', strtotime($aporte->fecha)) }}</span>
                            </div>

                            @if ($aporte->rendicion != null)
                                <div>
                                    <a class="rendicion"
                                        href="{{ asset("storage/ARCHIVOS/pagos/rendicion/$aporte->rendicion") }}"
                                        target="_blank" download="Rendicion de cuenta {{ $aporte->titulo }}"><i
                                            class="fas fa-download"></i> Descargar rendicion de cuenta</a>
                                </div>
                            @endif
                        </div>
                    @endforeach
                @else
                    <div class="no-data">
                        <i class="fas fa-hand-holding-usd"></i>
                        <p>No hay aportes vigentes actualmente.</p>
                    </div>
                @endif
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    <section id="contacto" class="contact-section">
        <div class="container">
            <h2 class="section-title">Contáctanos</h2>
            <p class="section-subtitle">¿Tienes alguna consulta? Estamos aquí para ayudarte</p>

            <div class="contact-container">
                <div class="contact-info">
                    <div class="contact-method">
                        <div class="contact-icon">
                            <i class="fas fa-map-marker-alt"></i>
                        </div>
                        <div class="contact-details">
                            <h3>Nuestra Ubicación</h3>
                            <p>{{ $empresa->ubicacion }}</p>
                        </div>
                    </div>

                    <div class="contact-method">
                        <div class="contact-icon">
                            <i class="fas fa-phone"></i>
                        </div>
                        <div class="contact-details">
                            <h3>Teléfono</h3>
                            <p>{{ $empresa->telefono }}</p>
                        </div>
                    </div>

                    <div class="contact-method">
                        <div class="contact-icon">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <div class="contact-details">
                            <h3>Correo Electrónico</h3>
                            <p>{{ $empresa->correo }}</p>
                        </div>
                    </div>

                    <div class="contact-method">
                        <div class="contact-icon">
                            <i class="fas fa-clock"></i>
                        </div>
                        <div class="contact-details">
                            <h3>Horario de Atención</h3>
                            <p>Lunes a Viernes: 8:00 AM - 3:00 PM</p>
                        </div>
                    </div>
                </div>

                <div class="contact-map">
                    {!! $empresa->mapa_ubi !!}
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-column">
                    <h3>Sistema APAFA</h3>
                    <p>Sistema de gestión para la Asociación de Padres de Familia de {{ $empresa->nombre }}.</p>
                    <div class="footer-social">
                        <a href="#" class="social-icon"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" class="social-icon"><i class="fab fa-twitter"></i></a>
                        <a href="#" class="social-icon"><i class="fab fa-instagram"></i></a>
                    </div>
                </div>

                <div class="footer-column">
                    <h3>Enlaces rápidos</h3>
                    <ul class="footer-links">
                        <li><a href="#">Inicio</a></li>
                        <li><a href="#nosotros">Nosotros</a></li>
                        <li><a href="#consulta">Consulta</a></li>
                        <li><a href="#reuniones">Reuniones</a></li>
                        <li><a href="#aportes">Aportes</a></li>
                        <li><a href="#contacto">Contacto</a></li>
                    </ul>
                </div>

                <div class="footer-column">
                    <h3>Contacto</h3>
                    <ul class="footer-links">
                        <li><i class="fas fa-map-marker-alt"></i> {{ $empresa->ubicacion }}</li>
                        <li><i class="fas fa-phone"></i> {{ $empresa->telefono }}</li>
                        <li><i class="fas fa-envelope"></i> {{ $empresa->correo }}</li>
                    </ul>
                </div>
            </div>

            <div class="footer-bottom">
                <p class="footer-text">© {{ date('Y') }} Sistema APAFA - Todos los derechos reservados</p>
            </div>
        </div>
    </footer>

    @if (session('CORRECTO'))
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "CORRECTO",
                    type: "success",
                    text: "{{ session('CORRECTO') }}",
                    styling: "bootstrap3"
                });
            });
        </script>
    @endif

    @if (session('INCORRECTO'))
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "INCORRECTO",
                    type: "error",
                    text: "{{ session('INCORRECTO') }}",
                    styling: "bootstrap3"
                });
            });
        </script>
    @endif

    @if (session('ERROR'))
        <script>
            document.getElementById("audio1").play();
            $(function notificacion() {
                new PNotify({
                    title: "ERROR",
                    type: "error",
                    text: "{{ session('ERROR') }}",
                    styling: "bootstrap3"
                });
            });
        </script>
    @endif

    <script>
        // Control de longitud de DNI
        let dni = document.getElementById("dni");
        dni.addEventListener("input", function() {
            if (this.value.length > 8) {
                this.value = this.value.slice(0, 8)
            }
        });

        // Navbar scroll effect
        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('.navbar');
            if (window.scrollY > 50) {
                navbar.classList.add('scrolled');
            } else {
                navbar.classList.remove('scrolled');
            }
        });

        // Función de búsqueda
        let buscar = document.getElementById("buscar");
        buscar.addEventListener("click", eventoBuscar);

        function eventoBuscar(e) {
            e.preventDefault();
            let dni = document.getElementById("dni").value;
            let res = document.getElementById("respuesta");

            if (dni == "") {
                res.innerHTML = `<div class="mensaje-error">Por favor ingrese su DNI para continuar</div>`;
                return false;
            } else if (dni.length < 8) {
                res.innerHTML = `<div class="mensaje-error">El DNI debe tener 8 dígitos</div>`;
                return false;
            } else {
                var ruta = "{{ url('buscar-padres') }}-" + dni;

                $.ajax({
                    url: ruta,
                    type: "get",
                    beforeSend: function() {
                        res.innerHTML = `<div class="mensaje-info">Buscando información...</div>`;
                    },
                    success: function(data) {
                        res.innerHTML =
                            `<div class="mensaje-success">Información encontrada, generando reporte...</div>`;
                        setTimeout(function() {
                            window.open(`historial-descargarPDF-${dni}`, '_blank');
                        }, 1000);
                    },
                    error: function(xhr, status, error) {
                        console.error("Error en la búsqueda:", error);
                        res.innerHTML =
                            `<div class="mensaje-error">El DNI ingresado no está registrado en nuestro sistema</div>`;
                    }
                });
            }
        }

        // Menú móvil
        document.addEventListener('DOMContentLoaded', function() {
            const menuToggle = document.getElementById('menu-toggle');
            const navbarMenu = document.getElementById('navbar-menu');
            const overlay = document.getElementById('overlay');
            const body = document.body;

            // Función para alternar el menú
            function toggleMenu() {
                navbarMenu.classList.toggle('active');
                overlay.classList.toggle('active');
                body.classList.toggle('menu-open');

                // Cambiar el ícono del botón
                if (navbarMenu.classList.contains('active')) {
                    menuToggle.innerHTML = '<i class="fas fa-times"></i>';
                } else {
                    menuToggle.innerHTML = '<i class="fas fa-bars"></i>';
                }
            }

            // Event listeners para abrir/cerrar el menú
            menuToggle.addEventListener('click', toggleMenu);
            overlay.addEventListener('click', toggleMenu);

            // Cerrar el menú cuando se hace clic en un enlace
            const navLinks = document.querySelectorAll('.nav-link');
            navLinks.forEach(link => {
                link.addEventListener('click', function() {
                    if (navbarMenu.classList.contains('active')) {
                        toggleMenu();
                    }
                });
            });

            // Cerrar el menú cuando se redimensiona la ventana a un tamaño grande
            window.addEventListener('resize', function() {
                if (window.innerWidth > 992 && navbarMenu.classList.contains('active')) {
                    toggleMenu();
                }
            });
        });
    </script>
</body>

</html>
