<!DOCTYPE html>
<html>

<head>
    <title>Reporte de aportes</title>
    <style>
        body {
            font-family: Arial, Helvetica, sans-serif;
        }

        table {
            font-size: 11px;
            width: 100%;
            margin-bottom: 20px;
        }

        td,
        th {
            border: 1px solid rgb(211, 211, 211);
            padding: 3px 10px;
            margin: 0;
        }

        .titulo {
            text-align: center;
            font-weight: bold;
            background: rgb(215, 215, 215);
        }

        .pagado {
            background: rgb(187, 255, 187);
        }

        .debe {
            background: rgb(255, 153, 153);
        }

        .tituloPrincipal {
            text-align: center;
            background: rgb(217, 218, 217);
            font-size: 16px;
            padding: 10px;
            margin: 0;
            font-weight: bold;
        }

        thead {
            position: fixed;
        }
    </style>
</head>

<body>

    <div class="page">
        <!-- Title Table -->
        <table>
            <tr>
                <td colspan="6" class="tituloPrincipal">
                    <?php $__currentLoopData = $tituloReunion; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e(strtoupper($item->titulo)); ?>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </td>
            </tr>
        </table>

        <!-- Attended Parents Table -->
        <table>
            <thead>
                <tr>
                    <td colspan="6" class="titulo pagado">LISTA DE PADRES DE FAMILIA ASISTIDOS</td>
                </tr>
                <tr>
                    <th>N°</th>
                    <th>Padre de familia</th>
                    <th>Reunión</th>
                    <th>Fecha de la reunion</th>
                    <th>Multa</th>
                    <th>Asistencia</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $padresAsistidos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($key + 1); ?></td>
                        <td><?php echo e($item->padre_ape_pat); ?> <?php echo e($item->padre_ape_mat); ?> <?php echo e($item->padre_nombres); ?> </td>
                        <td><?php echo e($item->titulo); ?></td>
                        <td><?php echo e($item->fecha); ?> <?php echo e($item->hora); ?></td>
                        <td>S/. <?php echo e($item->multa_precio); ?></td>
                        <td><?php echo e($item->asistencia); ?> <?php echo e($item->detalles); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <!-- Absent Parents Table -->
        <table>
            <thead>
                <tr>
                    <td colspan="6" class="titulo debe">LISTA DE PADRES DE FAMILIA QUE FALTARON</td>
                </tr>
                <tr>
                    <th>N°</th>
                    <th>Padre de familia</th>
                    <th>Reunión</th>
                    <th>Fecha de la reunion</th>
                    <th>Multa</th>
                    <th>Asistencia</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $padresNoAsistidos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($key + 1); ?></td>
                        <td><?php echo e($item->padre_ape_pat); ?> <?php echo e($item->padre_ape_mat); ?> <?php echo e($item->padre_nombres); ?> </td>
                        <td><?php echo e($item->titulo); ?></td>
                        <td><?php echo e($item->fecha); ?> <?php echo e($item->hora); ?></td>
                        <td>S/. <?php echo e($item->multa_precio); ?></td>
                        <td>Falta</td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <!-- Summary Table -->
        <table>
            <tbody>
                
                <?php $__currentLoopData = $sumaTotalNoAdeudados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td colspan="4"><b>Suma total noAdeudados</b></td>
                        <td colspan="2">S/. <?php echo e($item->sumaTotalNoAdeudados); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                
                <?php $__currentLoopData = $sumaTotalAdeudados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td colspan="4"><b>Suma total adeudados</b></td>
                        <td colspan="2">S/. <?php echo e($item->sumaTotalAdeudados); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                
                <tr>
                    <td colspan="4"><b>Suma total</b></td>
                    <td colspan="2">S/. <?php echo e($sumaTotal); ?></td>
                </tr>
            </tbody>
        </table>
    </div>
</body>

</html>
<?php /**PATH C:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\resources\views/vistas/reportes/reporte_reuniones.blade.php ENDPATH**/ ?>