
<?php $__env->startSection('titulo', 'Editar Pago'); ?>
<?php $__env->startSection('content'); ?>

    <?php if(session('CORRECTO')): ?>
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "CORRECTO",
                    type: "success",
                    text: "<?php echo e(session('CORRECTO')); ?>",
                    styling: "bootstrap3"
                });
            });
        </script>
    <?php endif; ?>
    <?php if(session('INCORRECTO')): ?>
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "INCORRECTO",
                    type: "error",
                    text: "<?php echo e(session('INCORRECTO')); ?>",
                    styling: "bootstrap3"
                });
            });
        </script>
    <?php endif; ?>

    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Editar Pago</h4>
                        <p class="card-category">Modifique los datos del pago</p>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('pagos.update', $pago[0]->id_pago)); ?>" method="POST"
                            enctype="multipart/form-data" id="form-editar-pago">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <?php if(isset($esPagoReunion) && $esPagoReunion): ?>
                                <input type="hidden" name="tipo_pago" value="reunion">
                            <?php endif; ?>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="pago_concepto">Concepto</label>
                                        <input type="text" class="form-control" value="<?php echo e($pago[0]->pago_concepto); ?>"
                                            readonly>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="monto_pago">Monto del pago</label>
                                        <?php if(isset($esPagoReunion) && $esPagoReunion): ?>
                                            <input type="number" step="0.01" class="form-control" name="monto_pago"
                                                value="<?php echo e($pago[0]->monto_pago); ?>" readonly>
                                            <small class="text-danger">El monto no se puede modificar por ser un pago de
                                                multa de reunión</small>
                                        <?php else: ?>
                                            <input type="number" step="0.01" class="form-control" id="monto_pago"
                                                name="monto_pago" value="<?php echo e(old('monto_pago', $pago[0]->monto_pago)); ?>"
                                                required data-monto-original="<?php echo e($pago[0]->monto_pago); ?>"
                                                <?php if(isset($montoMaximo)): ?> data-monto-maximo="<?php echo e($montoMaximo); ?>" <?php endif; ?>>

                                            <?php if(isset($montoMaximo)): ?>
                                                <small class="text-info">El monto máximo permitido es S/.
                                                    <?php echo e(number_format($montoMaximo, 2)); ?></small>
                                            <?php endif; ?>
                                            <div id="monto-error" class="text-danger d-none">El monto no puede ser mayor al
                                                monto máximo permitido</div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="comentario">Comentarios</label>
                                        <textarea class="form-control" name="comentario" rows="3"><?php echo e($pago[0]->comentario); ?></textarea>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="boucher">Boucher (Imagen o PDF)</label>
                                        <input type="file" class="form-control" name="boucher" accept="image/*,.pdf">
                                        <small class="text-muted">Suba un nuevo archivo solo si desea reemplazar el
                                            existente</small>
                                    </div>
                                </div>
                            </div>

                            <?php if($pago[0]->foto_boucher): ?>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>Boucher actual</label>
                                            <div>
                                                <?php
                                                    $extension = pathinfo($pago[0]->foto_boucher, PATHINFO_EXTENSION);
                                                ?>

                                                <?php if(in_array(strtolower($extension), ['jpg', 'jpeg', 'png', 'gif'])): ?>
                                                    <img src="<?php echo e(asset('storage/ARCHIVOS/pagos/' . $pago[0]->foto_boucher)); ?>"
                                                        style="max-width: 200px; max-height: 200px;" alt="Boucher actual">
                                                <?php else: ?>
                                                    <a href="<?php echo e(asset('storage/ARCHIVOS/pagos/' . $pago[0]->foto_boucher)); ?>"
                                                        target="_blank">
                                                        <i class="fas fa-file-pdf fa-2x text-danger"></i> Ver PDF actual
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <div class="row">
                                <div class="col-md-12 text-right">
                                    <a href="#" onclick="event.preventDefault(); window.history.back();" class="btn btn-secondary">Volver atrás</a>
                                    <button type="submit" class="btn btn-primary" id="btn-actualizar">Guardar
                                        cambios</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const montoPagoInput = document.getElementById('monto_pago');
            const montoError = document.getElementById('monto-error');
            const btnActualizar = document.getElementById('btn-actualizar');
            const formEditarPago = document.getElementById('form-editar-pago');

            // Solo aplicar validación si no es pago de reunión y tiene montoMaximo
            if (montoPagoInput && montoPagoInput.dataset.montoMaximo) {
                const montoMaximo = parseFloat(montoPagoInput.dataset.montoMaximo);
                const montoOriginal = parseFloat(montoPagoInput.dataset.montoOriginal);

                montoPagoInput.addEventListener('input', function() {
                    const valor = parseFloat(this.value) || 0;

                    if (valor > montoMaximo) {
                        montoError.classList.remove('d-none');
                        btnActualizar.disabled = true;
                        this.setCustomValidity('El monto no puede ser mayor al monto máximo permitido');
                    } else {
                        montoError.classList.add('d-none');
                        btnActualizar.disabled = false;
                        this.setCustomValidity('');
                    }
                });

                formEditarPago.addEventListener('submit', function(e) {
                    const valor = parseFloat(montoPagoInput.value) || 0;

                    if (valor > montoMaximo) {
                        e.preventDefault();
                        montoError.classList.remove('d-none');
                    }
                });
            }
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\resources\views/vistas/pagos/edit.blade.php ENDPATH**/ ?>