<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Historial de Padres</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
        }

        h1{
            font-size: 16px;
        }

        .nombrePadre {
            padding: 11px;
            background: rgba(26, 150, 123, 0.88);
            font-size: 12px;
            color: rgb(255, 255, 255);
            font-weight: bold;
        }

        .text-center {
            text-align: center;
        }

        .text-secondary {
            color: #fdfdfd;
            background: rgb(29, 105, 135);
            padding: 10px,
        }

        .card-block {
            margin-bottom: -40px;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 1rem;
        }

        .title {
            background-color: rgb(47, 128, 182) !important;
            color: white;
        }

        .table th,
        .table td {
            padding: 0.75rem;
            vertical-align: top;
            border: 1px solid #dee2e6;
        }

        .table th {
            background-color: #f9f9f9;
        }

        .table2 {
            margin-top: 60px;
        }

        .debe {
            background: rgb(255, 164, 164);
            padding: 5px 10px;
            color: rgb(61, 14, 14);
        }

        .pagado {
            background: rgb(161, 255, 161);
            padding: 5px 10px;
            color: rgb(11, 69, 38);
        }

        .monto__aportado,
        .multa {
            background: black;
            color: white;
            padding: 6px;
            font-weight: bold;
        }

        .monto__aporte {
            background: green;
            padding: 6px;
            color: white;
            font-weight: bold;
        }

        .monto {
            min-width: 30px;
        }

        .multas2 {
            min-width: 70px;
        }

        .asistencia {
            min-width: 120px;
        }
    </style>
</head>

<body>
    <h1 class="text-center text-secondary">HISTORIAL DE PADRES</h1>
    <div class="nombrePadre">
        PADRE DE FAMILIA:
        <?php $__currentLoopData = $nombrePadreFamilia; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo e($item->nombre); ?>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <div class="card-block table-responsive">
        <table class="table">
            <thead>
                <tr>
                    <th colspan="8" class="text-center title">APORTES</th>
                </tr>
                <tr>
                    <th>N°</th>
                    <th>Titulo</th>
                    <th>Descripcion</th>
                    <th>Monto que debe aportar</th>
                    <th class="monto">Monto aportado</th>
                    <th class="monto">Monto que debe</th>
                    <th>Fecha plazo</th>
                    <th>Estado</th>
                </tr>
            </thead>
            <tbody id="tbody">
                <?php $__currentLoopData = $historialAportes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($key + 1); ?></td>
                        <td><?php echo e($item->titulo); ?></td>
                        <td><?php echo e($item->descripcion); ?></td>
                        <td><?php echo e($item->monto); ?> <b> X <?php echo e($cantidadHijos); ?> hijos = S/. <?php echo e($item->monto_aporte); ?></b>
                        </td>
                        <td><span class="monto__aporte">S/. <?php echo e($item->monto_aportado); ?></span></td>
                        <td><span class="monto__aportado">S/. <?php echo e($item->debe); ?></span></td>
                        <td><?php echo e($item->fecha); ?></td>
                        <td>
                            <?php if($item->debe == null || $item->debe > 0): ?>
                                <span class="debe">Debe</span>
                            <?php else: ?>
                                <span class="pagado">Pagado</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <div class="card-block table-responsive">
        <table class="table table2">
            <thead>
                <tr>
                    <th colspan="6" class="text-center title">REUNIONES</th>
                </tr>
                <tr>
                    <th>N°</th>
                    <th>Titulo</th>
                    <th>Descripcion</th>
                    <th class="multas2">Multa</th>
                    <th>Fecha y hora de la reunion</th>
                    <th class="asistencia">Asistencia</th>
                </tr>
            </thead>
            <tbody id="tbodyreuniones">
                <?php $__currentLoopData = $historialReuniones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($key + 1); ?></td>
                        <td><?php echo e($item->titulo); ?></td>
                        <td><?php echo e($item->descripcion); ?></td>
                        <td><span class="multa">S/. <?php echo e($item->multa_precio); ?></span></td>
                        <td><?php echo e($item->fecha); ?> <?php echo e($item->hora); ?></td>
                        <td>
                            <?php if($item->asistencia == null and ($item->detalles == '' or $item->detalles == null)): ?>
                                <span class="debe">Falta</span>
                            <?php else: ?>
                                <?php if($item->asistencia != null or $item->asistencia != ''): ?>
                                    <span class="pagado"><?php echo e($item->asistencia); ?></span>
                                <?php else: ?>
                                    <span class="pagado"><?php echo e($item->detalles); ?></span>
                                <?php endif; ?>
                            <?php endif; ?>
                        </td>

                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <div class="card-block table-responsive">
        <table class="table table2">
            <thead>
                <tr>
                    <th colspan="5" class="text-center title">HISTORIAL DE PAGOS</th>
                </tr>
                <tr>
                    <th>N°</th>
                    <th>Registrado por</th>
                    <th>Fecha</th>
                    <th>Pago por concepto</th>
                    <th class="monto">Monto</th>
                </tr>
            </thead>
            <tbody id="tbodyreuniones">
                <?php $__currentLoopData = $historialPagos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($key + 1); ?></td>
                        <td><?php echo e($item->nombres); ?></td>
                        <td><?php echo e($item->fecha); ?></td>
                        <td><?php echo e($item->pago_concepto); ?></td>
                        <td><span class="multa">S/. <?php echo e($item->monto_pago); ?></span></td>

                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>


</body>

</html>
<?php /**PATH C:\laragon\www\sis_apafa\resources\views/vistas/historial/historialPDF.blade.php ENDPATH**/ ?>