
<?php $__env->startSection('titulo', 'Historial'); ?>
<?php $__env->startSection('content'); ?>

    <style>
        .encabezado__tabla {
            background-color: rgb(47, 128, 182) !important;
            color: white;
        }

        .multa,
        .monto {
            min-width: 100px;
        }

        .fecha_hora {
            min-width: 100px;
        }

        .resultado {
            background: rgba(26, 150, 123, 0.88);
            color: white;
            margin-bottom: 20px;
        }
    </style>

    


    <?php if(session('CORRECTO')): ?>
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "CORRECTO",
                    type: "success",
                    text: "<?php echo e(session('CORRECTO')); ?>",
                    styling: "bootstrap3"
                });
            });
        </script>
    <?php endif; ?>

    <?php if(session('INCORRECTO')): ?>
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "INCORRECTO",
                    type: "error",
                    text: "<?php echo e(session('INCORRECTO')); ?>",
                    styling: "bootstrap3"
                });
            });
        </script>
    <?php endif; ?>

    <h4 class="text-center text-secondary">HISTORIAL DE PADRES</h4>


    <form action="#" id="formBuscar">
        <div class="form-group row col-12 px-4">
            <div class="col-12 col-sm-9">
                <input autofocus type="number" id="dni" class="form-control p-3"
                    placeholder="Ingrese el DNI del padre de familia" name="txtdni">
            </div>
            <button id="buscar" class="btn btn-success col-12 col-sm-3 mt-2 mt-sm-0" type="submit">Buscar</button>
        </div>
    </form>

    <div class="card-block" style="margin-bottom: -40px">
        <div id="resultado"></div>
    </div>

    <div class="card-block table-responsive">
        
        <a href="" target="_blank" id="descarga" class="btn btn-danger mb-3 disabled"><i
                class="fas fa-file-pdf"></i> Descargar
            PDF</a>

        <table id="" class="display table table-striped" cellspacing="0" width="100%">
            <thead class="table-primary">
                <tr>
                    <th colspan="8" class="encabezado__tabla">APORTES</th>
                </tr>
                <tr>
                    <th>N°</th>
                    <th>Titulo</th>
                    <th>Descripcion</th>
                    <th>Monto que debe aportar</th>
                    <th class="monto">Monto aportado</th>
                    <th class="monto">Monto que debe</th>
                    <th>Fecha plazo</th>
                    <th>Estado</th>
                </tr>
            </thead>

            <tbody id="tbody">

            </tbody>
        </table>
    </div>

    <div class="card-block table-responsive">
        <table id="" class="display table table-striped" cellspacing="0" width="100%">
            <thead class="table-primary">
                <tr>
                    <th colspan="6" class="encabezado__tabla">REUNIONES</th>
                </tr>
                <tr>
                    <th>N°</th>
                    <th>Titulo</th>
                    <th>Descripcion</th>
                    <th class="multa">Multa</th>
                    <th class="fecha_hora">Fecha y hora de la reunion</th>
                    <th>Asistencia</th>
                    
                </tr>
            </thead>

            <tbody id="tbodyreuniones">

            </tbody>
        </table>
    </div>

    <div class="card-block table-responsive">
        <table id="" class="display table table-striped" cellspacing="0" width="100%">
            <thead class="table-primary">
                <tr>
                    <th colspan="8" class="encabezado__tabla">HISTORIAL DE PAGOS</th>
                </tr>
                <tr>
                    <th>N°</th>
                    <th>Registrado por</th>
                    <th>Fecha</th>
                    <th>Pago por concepto</th>
                    <th>Fecha</th>
                    <th>N° recibo</th>
                    <th>Boucher</th>
                    <th class="monto">Monto</th>
                </tr>
            </thead>

            <tbody id="tbodypagos">

            </tbody>
        </table>
    </div>


    <script>
        //enviando datos para la busqueda por ajax
        let formBuscar = document.getElementById("formBuscar");
        let dni = document.getElementById("dni");
        formBuscar.addEventListener("submit", buscarDatos);
        // formBuscar.addEventListener("blur", buscarDatos);
        // formBuscar.addEventListener("keyup", buscarDatos);
        //dni.addEventListener("blur", buscarDatos);
        //dni.addEventListener("keyup", buscarDatos);

        function buscarDatos(ev) {
            ev.preventDefault();
            let datos = $(this).serialize();
            $.ajax({
                url: "<?php echo e(route('historial.show')); ?>",
                type: "get",
                data: datos,

                success: function(response) {
                    let tbody = document.getElementById("tbody")
                    tbody.innerHTML = ""
                    let tbodyreuniones = document.getElementById("tbodyreuniones")
                    tbodyreuniones.innerHTML = ""
                    let tbodypagos = document.getElementById("tbodypagos")
                    tbodypagos.innerHTML = ""
                    let respuesta = document.getElementById("resultado")
                    respuesta.innerHTML =
                        `<div class="resultado p-3">PADRE DE FAMILIA: ${response.nombrePadreFamilia}</div>`

                    //habilitamos la descarga
                    let descarga = document.getElementById("descarga")
                    descarga.classList.remove("disabled")
                    descarga.setAttribute("href",
                        `<?php echo e(route('historial.descargaPDF', ['dni_padre' => ':dni_padre'])); ?>`.replace(
                            ':dni_padre', response
                            .dni)
                    );

                    response.historialAportes.forEach(function(element, index) {
                        let fila = document.createElement("tr")
                        fila.innerHTML = `
                        <td>${index+1}</td>
                        <td>${element.titulo}</td>
                        <td>${element.descripcion}</td>
                        <td>S/. ${element.monto} <b>X ${response.cantidadHijos} Hijos = S/. ${element.monto_aporte}<b></td>
                        <td><span class='text-white btn-sm bg-success font-weight-bold'>${element.monto_aportado==null ? "---": "S/. " + element.monto_aportado}</span></td>
                        <td><span class='text-white btn-sm bg-dark font-weight-bold'>${element.debe==null ? "---": "S/. " + element.debe}</span></td>
                        <td>${element.fecha}</td>
                        <td>${(element.debe==null | element.debe>0)? "<span class='btn btn-sm btn-danger'>Debe</span>": "<span class='btn btn-sm btn-success'>Pagado</span>"}</td>
                        `
                        tbody.appendChild(fila)
                    });

                    response.historialReuniones.forEach(function(element, index) {
                        let fila = document.createElement("tr")
                        let asistenciaHTML = "";

                        if (element.asistencia == null && (element.detalles == '' || element.detalles ==
                                null)) {
                            asistenciaHTML = "<span class='btn btn-sm btn-danger'>Falta</span>";
                        } else {
                            asistenciaHTML = element.asistencia !== null && element.asistencia !== '' ?
                                `<span class='btn btn-sm btn-success'>${element.asistencia}</span>` :
                                `<span class='btn btn-sm btn-success'>${element.detalles}</span>`;
                        }
                        fila.innerHTML = `
                        <td>${index+1}</td>
                        <td>${element.titulo}</td>
                        <td>${element.descripcion}</td>
                        <td><span class='text-white btn-sm bg-dark font-weight-bold'>S/. ${element.multa_precio}</span></td>
                        <td>${element.fecha +" "+ element.hora}</td>
                        <td>${asistenciaHTML}</td>
                        `
                        tbodyreuniones.appendChild(fila)
                        //<td>${element.estado=="ACTIVO" ? `<span class='btn btn-sm btn-success'>${element.estado}</span>`: `<span class='btn btn-sm btn-danger'>${element.estado}</span>`}</td>
                    });

                    response.historialPagos.forEach(function(element, index) {
                        let fila = document.createElement("tr")
                        fila.innerHTML = `
                        <td>${index+1}</td>
                        <td>${element.nombres}</td>
                        <td>${element.fecha}</td>
                        <td>${element.pago_concepto}</td>
                        <td>${element.fecha_pago_boucher}</td>
                        <td>${element.numero_pago_boucher}</td>
                        <td><a href="<?php echo e(asset('storage/ARCHIVOS/pagos/')); ?>/${element.foto_boucher}" target="_blank" class="text-dark font-weight-bold">Ver</a></td>
                        <td><span class='text-white btn-sm bg-dark font-weight-bold'>S/. ${element.monto_pago}</span></td></td>                        
                        `
                        tbodypagos.appendChild(fila)
                    });

                },
                error: function(datos) {
                    //deshabilitamos la descarga
                    let descarga = document.getElementById("descarga")
                    descarga.classList.add("disabled")
                    let tbody = document.getElementById("tbody")
                    tbody.innerHTML = ""
                    let tbodyreuniones = document.getElementById("tbodyreuniones")
                    tbodyreuniones.innerHTML = ""
                    let tbodypagos = document.getElementById("tbodypagos")
                    tbodypagos.innerHTML = ""

                    let respuesta = document.getElementById("resultado")
                    respuesta.innerHTML =
                        `<div class="alert alert-danger p-3">No se encontro el DNI</div>`
                    $(function notificacion() {
                        new PNotify({
                            title: "INCORRECTO",
                            type: "error",
                            text: `${datos.responseJSON.message}`,
                            styling: "bootstrap3"
                        });
                    });
                }
            });
        }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\resources\views/vistas/historial/index.blade.php ENDPATH**/ ?>