<!DOCTYPE html>
<html>

<head>
    <title>Reporte de aportes</title>
    <style>
        body {
            font-family: Arial, Helvetica, sans-serif;
        }

        table {
            font-size: 11px;
            width: 100%;
            margin-bottom: 20px;
        }

        td,
        th {
            border: 1px solid rgb(211, 211, 211);
            padding: 3px 10px;
            margin: 0;
        }

        .titulo {
            text-align: center;
            font-weight: bold;
            background: rgb(215, 215, 215);
        }

        .pagado {
            background: rgb(187, 255, 187);
        }

        .debe {
            background: rgb(255, 153, 153);
        }

        .tituloPrincipal {
            text-align: center;
            background: rgb(217, 218, 217);
            font-size: 16px;
            padding: 10px;
            margin: 0;
            font-weight: bold;
        }

        thead {
            position: fixed;
        }
    </style>
</head>

<body>

    <div class="page">
        <table>
            <thead>
                <tr>
                    <td colspan="8" class="tituloPrincipal">
                        <?php $__currentLoopData = $tituloAporte; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo e(strtoupper($item->titulo)); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </td>
                </tr>
            </thead>
            <thead>
                <tr>
                    <td colspan="8" class="titulo pagado">LISTA DE NO ADEUDADOS</td>
                </tr>
                <tr>
                    <th>N°</th>
                    <th>Padre de familia</th>
                    <th>Nombre aporte</th>
                    <th>Monto aporte</th>
                    <th>Monto aportado</th>
                    <th>Debe</th>
                </tr>
            </thead>
            <?php $__currentLoopData = $datosNoAdeudados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($key + 1); ?></td>
                    <td><?php echo e($item->padre_ape_pat); ?> <?php echo e($item->padre_ape_mat); ?> <?php echo e($item->padre_nombres); ?> </td>
                    <td><?php echo e($item->titulo); ?></td>
                    <td>S/. <?php echo e($item->monto_aporte); ?></td>
                    <td>S/. <?php echo e($item->monto_aportado); ?></td>
                    <td>--</td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <thead>
                <tr>
                    <td colspan="8" class="titulo debe">LISTA DE ADEUDADOS</td>
                </tr>
                <tr>
                    <th>N°</th>
                    <th>Padre de familia</th>
                    <th>Nombre aporte</th>
                    <th>Monto aporte</th>
                    <th>Monto aportado</th>
                    <th>Debe</th>
                    <th>Fecha</th>
                    <th>N° recibo</th>

                </tr>
            </thead>
            <?php $__currentLoopData = $datosAdeudados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($key + 1); ?></td>
                    <td><?php echo e($item->padre_ape_pat); ?> <?php echo e($item->padre_ape_mat); ?> <?php echo e($item->padre_nombres); ?></td>
                    <td><?php echo e($item->titulo); ?></td>
                    <td>S/. <?php echo e($item->monto_aporte); ?></td>
                    <td>S/. <?php echo e($item->monto_aportado); ?></td>
                    <td>S/. <?php echo e($item->monto_aporte - $item->monto_aportado); ?></td>
                    <td>-</td>
                    <td>-</td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <br>

            
            <?php $__currentLoopData = $sumaTotalNoAdeudados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td colspan="4"><b>Suma total noAdeudados</b></td>
                    <td colspan="2">S/. <?php echo e($item->sumaTotalNoAdeudados); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            
            <?php $__currentLoopData = $sumaTotalAdeudados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td colspan="4"><b>Suma total adeudados</b></td>
                    <td colspan="2">S/. <?php echo e($item->sumaTotalAdeudados); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            

            <tr>
                <td colspan="4"><b>Suma total</b></td>
                <td colspan="2">S/. <?php echo e($sumaTotal); ?></td>
            </tr>



    </div>
</body>

</html>
<?php /**PATH C:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\resources\views/vistas/reportes/reporte_aportes.blade.php ENDPATH**/ ?>